/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.debris.impl;

import com.bxm.fossicker.activity.constants.DebrisReceiveType;
import com.bxm.fossicker.activity.constants.DebrisStatus;
import com.bxm.fossicker.activity.constants.DistributedLockContant;
import com.bxm.fossicker.activity.domain.debris.ActivityAwardMapper;
import com.bxm.fossicker.activity.domain.debris.ActivityAwardPhaseMapper;
import com.bxm.fossicker.activity.domain.debris.ActivityAwardPhaseRecordMapper;
import com.bxm.fossicker.activity.facade.TelephoneChargeFacadeService;
import com.bxm.fossicker.activity.model.entity.ActivityAwardEntity;
import com.bxm.fossicker.activity.model.entity.ActivityAwardPhaseEntity;
import com.bxm.fossicker.activity.model.entity.ActivityAwardPhaseRecordEntity;
import com.bxm.fossicker.activity.model.param.debris.ActivityExchangeParam;
import com.bxm.fossicker.activity.model.param.debris.ActivityUserPageParam;
import com.bxm.fossicker.activity.model.param.debris.ActivityUserParam;
import com.bxm.fossicker.activity.model.vo.debris.ActivityBarrageVo;
import com.bxm.fossicker.activity.model.vo.debris.ActivityListVo;
import com.bxm.fossicker.activity.model.vo.debris.MyActivityAwardVo;
import com.bxm.fossicker.activity.model.vo.debris.ReceiveDebrisResultVo;
import com.bxm.fossicker.activity.service.config.ActivityDebrisProperties;
import com.bxm.fossicker.activity.service.debris.ActivityDebrisService;
import com.bxm.fossicker.activity.service.debris.cache.GrantDebrisCacheManager;
import com.bxm.fossicker.activity.service.debris.cache.UserDebrisCacheManager;
import com.bxm.fossicker.activity.service.debris.cache.UserLotteryCacheManager;
import com.bxm.fossicker.activity.service.debris.cache.UserTotalLotteryCacheManager;
import com.bxm.fossicker.base.facade.PointReportFacadeService;
import com.bxm.fossicker.base.facade.param.PointParam;
import com.bxm.fossicker.vo.BasicParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityDebrisServiceImpl
implements ActivityDebrisService {
    private static final Logger log = LoggerFactory.getLogger(ActivityDebrisServiceImpl.class);
    private final ActivityAwardMapper activityAwardMapper;
    private final ActivityAwardPhaseMapper activityAwardPhaseMapper;
    private final ActivityAwardPhaseRecordMapper activityAwardPhaseRecordMapper;
    private final UserDebrisCacheManager userDebrisCacheManager;
    private final GrantDebrisCacheManager grantDebrisCacheManager;
    private final SequenceCreater sequenceCreater;
    private final ActivityDebrisProperties activityDebrisProperties;
    private final TelephoneChargeFacadeService telephoneChargeFacadeService;
    private final DistributedLock distributedLock;
    private final PointReportFacadeService pointReportFacadeService;
    private final UserLotteryCacheManager userLotteryCacheManager;
    private final UserTotalLotteryCacheManager userTotalLotteryCacheManager;

    @Override
    public List<ActivityListVo> getActivityList(ActivityUserPageParam userPageParam) {
        List activityAwardList = this.activityAwardMapper.getActivityAwardList(userPageParam);
        activityAwardList.forEach(activityAwardItem -> activityAwardItem.setFirstReceive(Boolean.valueOf(!this.getHistoryReceiveActivityDebris(activityAwardItem.getActivityAwardId(), userPageParam.getUserId()))));
        return activityAwardList;
    }

    @Override
    public List<ActivityBarrageVo> getBarrageList() {
        List allActivityAwardList = this.activityAwardMapper.getAllActivityAward();
        return allActivityAwardList.stream().map(activityAwardEntity -> ActivityBarrageVo.builder().awardTitle(activityAwardEntity.getTitle()).phone(StringUtils.hideMobile((String)StringUtils.getRandomPhoneNum())).build()).limit(10L).collect(Collectors.toList());
    }

    @Override
    public List<MyActivityAwardVo> getMyAwardList(ActivityUserPageParam userPageParam) {
        List userAwardPhaseList = this.activityAwardPhaseMapper.getUserAwardPhaseList(userPageParam);
        userAwardPhaseList.forEach(activityAwardItem -> activityAwardItem.setFirstReceive(Boolean.valueOf(!this.getHistoryReceiveActivityDebris(activityAwardItem.getActivityAwardId(), userPageParam.getUserId()))));
        return userAwardPhaseList;
    }

    @Override
    public Message receiveDebris(ActivityUserParam activityUserParam) {
        String requestId;
        String key = this.buildReceiveDebrisKey(activityUserParam.getActivityAwardId(), activityUserParam.getUserId());
        if (!this.distributedLock.lock(key, requestId = this.sequenceCreater.nextStringId(), 2L, TimeUnit.SECONDS)) {
            return Message.build((boolean)false, (String)"\u9886\u53d6\u788e\u7247\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
        }
        this.pointReportFacadeService.add(this.buildJoinActivityPointParam(activityUserParam, 1));
        boolean hasHistoryReceive = this.getHistoryReceiveActivityDebris(activityUserParam.getActivityAwardId(), activityUserParam.getUserId());
        ActivityAwardEntity activityAwardEntity = this.activityAwardMapper.selectByPrimaryKey(activityUserParam.getActivityAwardId());
        ActivityAwardPhaseEntity userPhaseInfo = this.activityAwardPhaseMapper.getCurrentPhaseInfo(activityUserParam.getActivityAwardId(), activityUserParam.getUserId());
        if (hasHistoryReceive) {
            return Message.build((boolean)true).addParam("resultVO", (Object)ReceiveDebrisResultVo.builder().success(Boolean.valueOf(true)).targetDebrisNum(userPhaseInfo.getTargetNum()).currentDebrisNum(userPhaseInfo.getCurrentNum()).mainPicture(userPhaseInfo.getAwardPicture()).title(userPhaseInfo.getAwardTitle()).activityAwardId(activityUserParam.getActivityAwardId()).build());
        }
        ActivityAwardPhaseEntity dbPhaseInfo = this.handleFirstDebris(activityUserParam, activityAwardEntity, userPhaseInfo);
        this.distributedLock.unlock(key, requestId);
        return Message.build((boolean)true).addParam("resultVO", (Object)ReceiveDebrisResultVo.builder().success(Boolean.valueOf(true)).targetDebrisNum(dbPhaseInfo.getTargetNum()).currentDebrisNum(dbPhaseInfo.getCurrentNum()).mainPicture(dbPhaseInfo.getAwardPicture()).title(dbPhaseInfo.getAwardTitle()).activityAwardId(activityUserParam.getActivityAwardId()).build());
    }

    @Override
    public Message addUserDebris(ActivityUserParam activityUserParam) {
        String requestId;
        String key = this.buildReceiveDebrisKey(activityUserParam.getActivityAwardId(), activityUserParam.getUserId());
        if (!this.distributedLock.lock(key, requestId = this.sequenceCreater.nextStringId(), 2L, TimeUnit.SECONDS)) {
            return Message.build((boolean)false, (String)"\u9886\u53d6\u788e\u7247\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
        }
        this.pointReportFacadeService.add(this.buildJoinActivityPointParam(activityUserParam, 2));
        this.userTotalLotteryCacheManager.incrementUserLotteryNum(activityUserParam.getUserId());
        this.userLotteryCacheManager.incrementUserLotteryNum(activityUserParam.getUserId());
        ActivityAwardEntity activityAwardEntity = this.activityAwardMapper.selectByPrimaryKey(activityUserParam.getActivityAwardId());
        ActivityAwardPhaseEntity userPhaseInfo = this.activityAwardPhaseMapper.getCurrentPhaseInfo(activityUserParam.getActivityAwardId(), activityUserParam.getUserId());
        if (Objects.isNull(userPhaseInfo)) {
            log.info("\u8c03\u7528\u7b2c\u4e8c\u6b21\u9886\u53d6\u63a5\u53e3\uff0c\u4f46\u662f\u672a\u9996\u6b21\u9886\u53d6\uff0c\u6d3b\u52a8\u5956\u54c1id\uff1a{}, \u7528\u6237id\uff1a{} ", (Object)activityUserParam.getActivityAwardId(), (Object)activityUserParam.getUserId());
            userPhaseInfo = this.handleFirstDebris(activityUserParam, activityAwardEntity, null);
        }
        int currentWatchNum = this.userDebrisCacheManager.increaseWatchNum(activityUserParam.getUserId(), userPhaseInfo.getId());
        boolean grantDebris = this.grantDebrisCacheManager.hasGrantDebris(activityAwardEntity.getType(), userPhaseInfo.getCurrentNum() + 1, currentWatchNum);
        log.info("\u7528\u6237\u9886\u53d6\u788e\u7247\u7ed3\u679c\uff1a{}\uff0c\u7528\u6237id\uff1a{}, \u6d3b\u52a8id\uff1a{}, \u671f\u6570id\uff1a{}\uff0c\u5f53\u524d\u788e\u7247\u4e2a\u6570\uff1a{}, \u89c2\u770b\u89c6\u9891\u6b21\u6570\uff1a{}", new Object[]{grantDebris, activityUserParam.getUserId(), activityUserParam.getActivityAwardId(), userPhaseInfo.getId(), userPhaseInfo.getCurrentNum(), currentWatchNum});
        if (Boolean.FALSE.equals(grantDebris)) {
            this.distributedLock.unlock(key, requestId);
            return Message.build((boolean)true).addParam("resultVO", (Object)ReceiveDebrisResultVo.builder().success(Boolean.valueOf(false)).mainPicture(activityAwardEntity.getMainPicture()).title(activityAwardEntity.getTitle()).activityAwardId(activityAwardEntity.getId()).targetDebrisNum(userPhaseInfo.getTargetNum()).currentDebrisNum(userPhaseInfo.getCurrentNum()).build());
        }
        this.addActivityAwardPhaseRecord(activityUserParam, userPhaseInfo, DebrisReceiveType.WATCH_RECEIVE);
        this.activityAwardPhaseMapper.increasePhaseDebrisNum(userPhaseInfo.getId());
        this.pointReportFacadeService.add(this.buildAddDebrisPointParam(activityUserParam, 2));
        this.distributedLock.unlock(key, requestId);
        return Message.build((boolean)true).addParam("resultVO", (Object)ReceiveDebrisResultVo.builder().success(Boolean.valueOf(true)).targetDebrisNum(userPhaseInfo.getTargetNum()).currentDebrisNum(Integer.valueOf(userPhaseInfo.getCurrentNum() + 1)).mainPicture(userPhaseInfo.getAwardPicture()).title(userPhaseInfo.getAwardTitle()).activityAwardId(activityUserParam.getActivityAwardId()).build());
    }

    @Override
    public Message conversionDebris(ActivityExchangeParam activityExchangeParam) {
        String requestId;
        String key = this.buildConversionDebrisKey(activityExchangeParam.getPhaseId());
        if (!this.distributedLock.lock(key, requestId = this.sequenceCreater.nextStringId(), 2L, TimeUnit.SECONDS)) {
            return Message.build((boolean)false, (String)"\u5151\u6362\u8bdd\u8d39\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
        }
        ActivityAwardPhaseEntity phaseEntity = this.activityAwardPhaseMapper.selectAvailablePhase(activityExchangeParam.getPhaseId(), activityExchangeParam.getUserId());
        if (Objects.isNull(phaseEntity)) {
            log.error("\u5151\u6362\u5931\u8d25\uff0c\u671f\u6570\u4e0d\u5b58\u5728\uff0c\u5956\u54c1id\uff1a{}, \u671f\u6570id\uff1a{}\uff0c\u7528\u6237id\uff1a{}", new Object[]{activityExchangeParam.getActivityAwardId(), activityExchangeParam.getPhaseId(), activityExchangeParam.getUserId()});
            return Message.build((boolean)true).addParam("resultVO", (Object)false);
        }
        this.telephoneChargeFacadeService.addTelephoneChargeList(activityExchangeParam.getUserId(), Byte.valueOf((byte)2));
        this.pointReportFacadeService.add(this.buildConversionDebrisPointParam(activityExchangeParam));
        ActivityAwardPhaseEntity updateEntity = new ActivityAwardPhaseEntity();
        updateEntity.setId(phaseEntity.getId());
        updateEntity.setStatus(Integer.valueOf(DebrisStatus.EXCHANGE.getCode()));
        updateEntity.setUsedTime(new Date());
        this.activityAwardPhaseMapper.updateByPrimaryKeySelective(updateEntity);
        log.info("\u5151\u6362\u6210\u529f\uff0c\u5956\u54c1id\uff1a{}, \u671f\u6570id\uff1a{}\uff0c\u7528\u6237id\uff1a{}", new Object[]{activityExchangeParam.getActivityAwardId(), activityExchangeParam.getPhaseId(), activityExchangeParam.getUserId()});
        this.distributedLock.unlock(key, requestId);
        return Message.build((boolean)true).addParam("resultVO", (Object)true);
    }

    @Override
    public Boolean getHistoryReceiveDebris(Long userId) {
        return this.getHistoryReceiveActivityDebris(this.activityDebrisProperties.getChargeActivityId(), userId);
    }

    @Override
    public void clearYesterdayDebris() {
        this.activityAwardPhaseMapper.clearExpiredPhase();
    }

    @Override
    public boolean checkPopForDebrisBaskPop(Long userId) {
        return true;
    }

    private boolean getHistoryReceiveActivityDebris(Long activityAwardId, Long userId) {
        ActivityAwardPhaseEntity userPhaseInfo = this.activityAwardPhaseMapper.getCurrentPhaseInfo(activityAwardId, userId);
        if (userPhaseInfo == null) {
            return false;
        }
        List recordList = this.activityAwardPhaseRecordMapper.getRecordListByPhaseId(userPhaseInfo.getId());
        return !CollectionUtils.isEmpty((Collection)recordList);
    }

    private String buildReceiveDebrisKey(Long activityAwardId, Long userId) {
        return DistributedLockContant.RECEIVE_DEBRIS_KEY.copy().appendKey((Object)activityAwardId).appendKey((Object)userId).gen();
    }

    private String buildConversionDebrisKey(Long phaseId) {
        return DistributedLockContant.CONVERSION_DEBRIS_KEY.copy().appendKey((Object)phaseId).gen();
    }

    private void addActivityAwardPhaseRecord(ActivityUserParam activityUserParam, ActivityAwardPhaseEntity phaseEntity, DebrisReceiveType debrisReceiveType) {
        ActivityAwardPhaseRecordEntity recordEntity = new ActivityAwardPhaseRecordEntity();
        recordEntity.setId(this.sequenceCreater.nextLongId());
        recordEntity.setAwardId(activityUserParam.getActivityAwardId());
        recordEntity.setCreateTime(new Date());
        recordEntity.setSource(Integer.valueOf(debrisReceiveType.getCode()));
        recordEntity.setUserId(activityUserParam.getUserId());
        recordEntity.setPhaseId(phaseEntity.getId());
        this.activityAwardPhaseRecordMapper.insertSelective(recordEntity);
    }

    private ActivityAwardPhaseEntity initActivityAwardPhase(ActivityUserParam activityUserParam, ActivityAwardEntity activityAwardEntity, Integer initDebrisNum) {
        ActivityAwardPhaseEntity phaseEntity = new ActivityAwardPhaseEntity();
        phaseEntity.setId(this.sequenceCreater.nextLongId());
        phaseEntity.setAwardId(activityUserParam.getActivityAwardId());
        phaseEntity.setAwardPicture(activityAwardEntity.getMainPicture());
        phaseEntity.setAwardTitle(activityAwardEntity.getTitle());
        phaseEntity.setCreateTime(new Date());
        phaseEntity.setCurrentNum(initDebrisNum);
        phaseEntity.setTargetNum(activityAwardEntity.getPhaseNum());
        phaseEntity.setType(activityAwardEntity.getType());
        phaseEntity.setUserId(activityUserParam.getUserId());
        phaseEntity.setStatus(Integer.valueOf(DebrisStatus.AVAILABLE.getCode()));
        this.activityAwardPhaseMapper.insertSelective(phaseEntity);
        return phaseEntity;
    }

    private ActivityAwardPhaseEntity handleFirstDebris(ActivityUserParam activityUserParam, ActivityAwardEntity activityAwardEntity, ActivityAwardPhaseEntity userPhaseInfo) {
        log.info("\u7528\u6237\u5f53\u65e5\u9996\u6b21\u9886\u53d6\u788e\u7247\uff1a\u7528\u6237id\uff1a{}, \u5956\u54c1id\uff1a{}", (Object)activityUserParam.getUserId(), (Object)activityUserParam.getActivityAwardId());
        ActivityAwardPhaseEntity realPhaseInfo = userPhaseInfo;
        if (Objects.isNull(userPhaseInfo)) {
            realPhaseInfo = this.initActivityAwardPhase(activityUserParam, activityAwardEntity, 1);
        }
        this.addActivityAwardPhaseRecord(activityUserParam, realPhaseInfo, DebrisReceiveType.DIRECT_RECEIVE);
        this.pointReportFacadeService.add(this.buildAddDebrisPointParam(activityUserParam, 1));
        if (this.activityDebrisProperties.getFirstReceiveAddLotteryNum().booleanValue()) {
            this.userLotteryCacheManager.incrementUserLotteryNum(activityUserParam.getUserId());
            this.userTotalLotteryCacheManager.incrementUserLotteryNum(activityUserParam.getUserId());
        }
        return realPhaseInfo;
    }

    private PointParam buildJoinActivityPointParam(ActivityUserParam activityUserParam, Integer type) {
        return PointParam.build((BasicParam)activityUserParam).e("3034").ev("107." + activityUserParam.getActivityAwardId() + "." + type).put("uid", String.valueOf(activityUserParam.getUserId()));
    }

    private PointParam buildAddDebrisPointParam(ActivityUserParam activityUserParam, Integer type) {
        return PointParam.build((BasicParam)activityUserParam).e("3034").ev("108." + activityUserParam.getActivityAwardId() + "." + type).put("uid", String.valueOf(activityUserParam.getUserId()));
    }

    private PointParam buildConversionDebrisPointParam(ActivityExchangeParam activityExchangeParam) {
        return PointParam.build((BasicParam)activityExchangeParam).e("3034").ev("109." + activityExchangeParam.getActivityAwardId()).put("uid", String.valueOf(activityExchangeParam.getUserId()));
    }

    public ActivityDebrisServiceImpl(ActivityAwardMapper activityAwardMapper, ActivityAwardPhaseMapper activityAwardPhaseMapper, ActivityAwardPhaseRecordMapper activityAwardPhaseRecordMapper, UserDebrisCacheManager userDebrisCacheManager, GrantDebrisCacheManager grantDebrisCacheManager, SequenceCreater sequenceCreater, ActivityDebrisProperties activityDebrisProperties, TelephoneChargeFacadeService telephoneChargeFacadeService, DistributedLock distributedLock, PointReportFacadeService pointReportFacadeService, UserLotteryCacheManager userLotteryCacheManager, UserTotalLotteryCacheManager userTotalLotteryCacheManager) {
        this.activityAwardMapper = activityAwardMapper;
        this.activityAwardPhaseMapper = activityAwardPhaseMapper;
        this.activityAwardPhaseRecordMapper = activityAwardPhaseRecordMapper;
        this.userDebrisCacheManager = userDebrisCacheManager;
        this.grantDebrisCacheManager = grantDebrisCacheManager;
        this.sequenceCreater = sequenceCreater;
        this.activityDebrisProperties = activityDebrisProperties;
        this.telephoneChargeFacadeService = telephoneChargeFacadeService;
        this.distributedLock = distributedLock;
        this.pointReportFacadeService = pointReportFacadeService;
        this.userLotteryCacheManager = userLotteryCacheManager;
        this.userTotalLotteryCacheManager = userTotalLotteryCacheManager;
    }
}

