/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.debris.impl;

import com.bxm.fossicker.activity.constants.DistributedLockContant;
import com.bxm.fossicker.activity.domain.ActivityTelephoneChargeMapper;
import com.bxm.fossicker.activity.domain.debris.ActivityRedPacketMapper;
import com.bxm.fossicker.activity.domain.debris.ActivityRedPacketRecordMapper;
import com.bxm.fossicker.activity.enums.DebrisRedPacketStatusEnum;
import com.bxm.fossicker.activity.model.dto.debris.DebrisRedPacketDTO;
import com.bxm.fossicker.activity.model.entity.ActivityRedPacket;
import com.bxm.fossicker.activity.model.entity.ActivityRedPacketRecord;
import com.bxm.fossicker.activity.model.param.debris.ReceiveRedPacketParam;
import com.bxm.fossicker.activity.model.vo.debris.ReceiveRedPacketResultVo;
import com.bxm.fossicker.activity.model.vo.debris.RedPacketVo;
import com.bxm.fossicker.activity.service.debris.ActivityRedPacketService;
import com.bxm.fossicker.activity.service.debris.cache.UserLotteryCacheManager;
import com.bxm.fossicker.activity.service.debris.cache.UserTotalLotteryCacheManager;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityRedPacketServiceImpl
implements ActivityRedPacketService {
    private final ActivityRedPacketMapper activityRedPacketMapper;
    private final ActivityRedPacketRecordMapper activityRedPacketRecordMapper;
    private final UserLotteryCacheManager userLotteryCacheManager;
    private final SequenceCreater sequenceCreater;
    private final DistributedLock distributedLock;
    private final ActivityTelephoneChargeMapper activityTelephoneChargeMapper;
    private final AccountFacadeService accountFacadeService;
    private final UserTotalLotteryCacheManager userTotalLotteryCacheManager;

    @Override
    public List<RedPacketVo> getDebrisRedPacketList(Long userId) {
        List allRedPacketList = this.activityRedPacketMapper.getAllList(userId);
        if (CollectionUtils.isEmpty((Collection)allRedPacketList)) {
            return Collections.emptyList();
        }
        DebrisRedPacketDTO lastRedPacketDTO = (DebrisRedPacketDTO)allRedPacketList.get(allRedPacketList.size() - 1);
        Integer maxTargetLotteryNum = lastRedPacketDTO.getTargetLotteryNum();
        Integer currentUserLotteryNum = this.userLotteryCacheManager.getUserLotteryNum(userId);
        ArrayList<RedPacketVo> resultList = new ArrayList<RedPacketVo>();
        boolean lastReceive = true;
        for (DebrisRedPacketDTO debrisRedPacketDTO : allRedPacketList) {
            RedPacketVo redPacketVo = new RedPacketVo();
            redPacketVo.setRedPacketId(debrisRedPacketDTO.getId());
            redPacketVo.setCurrentLotteryNum(currentUserLotteryNum > maxTargetLotteryNum ? maxTargetLotteryNum : currentUserLotteryNum);
            redPacketVo.setTargetLotteryNum(debrisRedPacketDTO.getTargetLotteryNum());
            if (!lastReceive) {
                redPacketVo.setStatus(Integer.valueOf(DebrisRedPacketStatusEnum.WAIT_LOCK.getCode()));
            } else if (Boolean.FALSE.equals(Objects.isNull(debrisRedPacketDTO.getRecordId()))) {
                redPacketVo.setStatus(Integer.valueOf(DebrisRedPacketStatusEnum.RECEIVE.getCode()));
            } else {
                lastReceive = false;
                redPacketVo.setStatus(Integer.valueOf(DebrisRedPacketStatusEnum.UNLOCK.getCode()));
            }
            resultList.add(redPacketVo);
        }
        return resultList;
    }

    @Override
    public Message receiveRedPacket(ReceiveRedPacketParam receiveRedPacketParam) {
        String requestId;
        String key = this.buildReceiveDebrisRedPacketKey(receiveRedPacketParam.getUserId(), receiveRedPacketParam.getRedPacketId());
        if (!this.distributedLock.lock(key, requestId = this.sequenceCreater.nextStringId(), 2L, TimeUnit.SECONDS)) {
            this.distributedLock.unlock(key, requestId);
            return Message.build((boolean)false, (String)"\u9886\u53d6\u7ea2\u5305\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
        }
        ActivityRedPacket activityRedPacket = this.activityRedPacketMapper.selectByPrimaryKey(receiveRedPacketParam.getRedPacketId());
        if (Objects.isNull(activityRedPacket)) {
            this.distributedLock.unlock(key, requestId);
            return Message.build((boolean)false).setMessage("\u7ea2\u5305\u4e0d\u5b58\u5728");
        }
        List todayRedPacketRecord = this.activityRedPacketRecordMapper.getTodayRecordByRedPacketId(receiveRedPacketParam.getUserId(), receiveRedPacketParam.getRedPacketId());
        if (Boolean.FALSE.equals(CollectionUtils.isEmpty((Collection)todayRedPacketRecord))) {
            this.distributedLock.unlock(key, requestId);
            return Message.build((boolean)false).setMessage("\u4eca\u65e5\u60a8\u5df2\u9886\u53d6\u8be5\u7ea2\u5305");
        }
        Integer targetLotteryNum = activityRedPacket.getTargetLotteryNum();
        if (targetLotteryNum > this.userLotteryCacheManager.getUserLotteryNum(receiveRedPacketParam.getUserId())) {
            this.distributedLock.unlock(key, requestId);
            return Message.build((boolean)true).addParam("resultVO", (Object)ReceiveRedPacketResultVo.builder().goldCoinNum(activityRedPacket.getGoldCoinNum()).hasReceive(Boolean.valueOf(false)).redPacketVoList(this.getDebrisRedPacketList(receiveRedPacketParam.getUserId())).build());
        }
        ActivityRedPacketRecord redPacketRecord = new ActivityRedPacketRecord();
        redPacketRecord.setCreateTime(new Date());
        redPacketRecord.setId(this.sequenceCreater.nextLongId());
        redPacketRecord.setUserId(receiveRedPacketParam.getUserId());
        redPacketRecord.setRedPacketId(receiveRedPacketParam.getRedPacketId());
        this.activityRedPacketRecordMapper.insertSelective(redPacketRecord);
        this.accountFacadeService.goldRebate(GoldRebateParam.builder().amount(BigDecimal.valueOf(activityRedPacket.getGoldCoinNum().intValue())).userGoldFlowType(UserGoldFlowTypeEnum.DEBRIS_RED_PACKET).relationId(activityRedPacket.getId()).userId(receiveRedPacketParam.getUserId()).build());
        this.distributedLock.unlock(key, requestId);
        return Message.build((boolean)true).addParam("resultVO", (Object)ReceiveRedPacketResultVo.builder().goldCoinNum(activityRedPacket.getGoldCoinNum()).hasReceive(Boolean.valueOf(true)).redPacketVoList(this.getDebrisRedPacketList(receiveRedPacketParam.getUserId())).build());
    }

    @Override
    public Boolean hasReceiveCharge(Long userId) {
        return this.activityTelephoneChargeMapper.countByUserIdAndSource(userId, Integer.valueOf(3)) > 0;
    }

    @Override
    public void increaseLotteryNum(Long userId) {
        this.userLotteryCacheManager.incrementUserLotteryNum(userId);
        this.userTotalLotteryCacheManager.incrementUserLotteryNum(userId);
    }

    private String buildReceiveDebrisRedPacketKey(Long userId, Long redPacketId) {
        return DistributedLockContant.RECEIVE_DEBRIS_RED_PACKET_KEY.copy().appendKey((Object)userId).appendKey((Object)redPacketId).gen();
    }

    public ActivityRedPacketServiceImpl(ActivityRedPacketMapper activityRedPacketMapper, ActivityRedPacketRecordMapper activityRedPacketRecordMapper, UserLotteryCacheManager userLotteryCacheManager, SequenceCreater sequenceCreater, DistributedLock distributedLock, ActivityTelephoneChargeMapper activityTelephoneChargeMapper, AccountFacadeService accountFacadeService, UserTotalLotteryCacheManager userTotalLotteryCacheManager) {
        this.activityRedPacketMapper = activityRedPacketMapper;
        this.activityRedPacketRecordMapper = activityRedPacketRecordMapper;
        this.userLotteryCacheManager = userLotteryCacheManager;
        this.sequenceCreater = sequenceCreater;
        this.distributedLock = distributedLock;
        this.activityTelephoneChargeMapper = activityTelephoneChargeMapper;
        this.accountFacadeService = accountFacadeService;
        this.userTotalLotteryCacheManager = userTotalLotteryCacheManager;
    }
}

