/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.gold.strategy;

import com.bxm.fossicker.activity.model.param.GoldDoubleParam;
import com.bxm.fossicker.activity.service.gold.strategy.DoubleGoldStrategyService;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.newidea.component.tools.StringUtils;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDoubleGoldStrategyService
implements DoubleGoldStrategyService {
    @Autowired
    private AccountFacadeService accountFacadeService;

    public Integer showGoldNum(Integer awardGoldNum, String currentVersion) {
        if (StringUtils.compareVersion((String)currentVersion, (String)"1.3.0") < 0) {
            return 2 * awardGoldNum;
        }
        return 3 * awardGoldNum;
    }

    public void addGold(BigDecimal rewardNum, GoldDoubleParam goldDoubleParam) {
        String currentVersion = goldDoubleParam.getCurVer();
        BigDecimal rewardNumDouble = rewardNum.multiply(new BigDecimal("2"));
        if (StringUtils.compareVersion((String)currentVersion, (String)"1.3.0") < 0) {
            rewardNumDouble = rewardNum;
        }
        GoldRebateParam goldRebateParam = GoldRebateParam.builder().amount(rewardNumDouble).userGoldFlowType(UserGoldFlowTypeEnum.DOUBLE_AWARD).userId(goldDoubleParam.getUserId()).relationId(Long.valueOf(StringUtils.isBlank((CharSequence)goldDoubleParam.getRelationId()) ? 0L : Long.parseLong(goldDoubleParam.getRelationId()))).build();
        this.accountFacadeService.goldRebate(goldRebateParam);
    }
}

