/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.config.TaskConfig;
import com.bxm.fossicker.activity.service.AccountIntegrationService;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import java.math.BigDecimal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AccountIntegrationServiceImpl
implements AccountIntegrationService {
    private static final Logger log = LogManager.getLogger(AccountIntegrationServiceImpl.class);
    private final AccountFacadeService accountFacadeService;
    private final TaskConfig taskConfig;

    @Autowired
    public AccountIntegrationServiceImpl(AccountFacadeService accountFacadeService, TaskConfig taskConfig) {
        this.accountFacadeService = accountFacadeService;
        this.taskConfig = taskConfig;
    }

    @Override
    @Async
    public void rewardSign(Long userId, BigDecimal amount) {
        this.accountFacadeService.goldRebate(this.build(userId, UserGoldFlowTypeEnum.SIGN, amount));
    }

    @Override
    @Async
    public void rewardTask(Long userId, BigDecimal amount, Long taskId) {
        this.accountFacadeService.goldRebate(this.build(userId, UserGoldFlowTypeEnum.TASK, amount, taskId));
    }

    @Override
    @Async
    public void rewardFinishView(Long userId) {
        this.accountFacadeService.goldRebate(this.build(userId, UserGoldFlowTypeEnum.BROWSER_COMMODITY, this.taskConfig.getGoodsViewReward()));
    }

    @Override
    @Async
    public void rewardDayGold(Long userId, BigDecimal amount, Long relationId) {
        this.accountFacadeService.goldRebate(this.build(userId, UserGoldFlowTypeEnum.DAY_GOLD, amount, relationId));
    }

    @Override
    @Async
    public void rewardNewUserRedPacket(Long userId) {
        this.accountFacadeService.goldRebate(this.build(userId, UserGoldFlowTypeEnum.NEW_USER_RED_PACKET, this.taskConfig.getNewUserRedPacket()));
    }

    @Override
    @Async
    public void rewardShareView(Long userId) {
        this.accountFacadeService.goldRebate(this.build(userId, UserGoldFlowTypeEnum.SHARE_BROWSER_COMMODITY, this.taskConfig.getGoodsViewReward()));
    }

    private GoldRebateParam build(Long userId, UserGoldFlowTypeEnum userGoldFlowTypeEnum, BigDecimal amount) {
        return this.build(userId, userGoldFlowTypeEnum, amount, null);
    }

    private GoldRebateParam build(Long userId, UserGoldFlowTypeEnum userGoldFlowTypeEnum, BigDecimal amount, Long relationId) {
        GoldRebateParam accountTranParam = new GoldRebateParam();
        accountTranParam.setUserId(userId);
        accountTranParam.setUserGoldFlowType(userGoldFlowTypeEnum);
        accountTranParam.setAmount(amount);
        accountTranParam.setRelationId(relationId);
        return accountTranParam;
    }
}

