/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.domain.UserInviteRelationMapper;
import com.bxm.fossicker.activity.facade.ActivityFacadeService;
import com.bxm.fossicker.activity.facade.model.LoginRewardFacadeDTO;
import com.bxm.fossicker.activity.facade.model.TreasureBoxFacadeDTO;
import com.bxm.fossicker.activity.model.vo.TreasureBoxVO;
import com.bxm.fossicker.activity.service.TemporaryActivityService;
import com.bxm.fossicker.activity.service.TreasureBoxActivityService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.activity.service.debris.cache.UserLotteryCacheManager;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityFacadeServiceImpl
implements ActivityFacadeService {
    @Autowired
    private TreasureBoxActivityService treasureBoxActivityService;
    @Autowired
    private ActivityProperties activityProperties;
    @Resource
    private UserInviteRelationMapper userInviteRelationMapper;
    @Autowired
    private TemporaryActivityService temporaryActivityService;
    @Autowired
    private UserLotteryCacheManager userLotteryCacheManager;

    public TreasureBoxFacadeDTO treasureBox(Long userId) {
        TreasureBoxVO treasureBoxVO = this.treasureBoxActivityService.treasureBox(userId);
        if (Objects.nonNull(treasureBoxVO)) {
            TreasureBoxFacadeDTO dto = new TreasureBoxFacadeDTO();
            BeanUtils.copyProperties((Object)treasureBoxVO, (Object)dto);
            return dto;
        }
        return null;
    }

    public Integer differInviteNum(Long userId) {
        int userRewardNum;
        int allNum = this.userInviteRelationMapper.selectFriendsNumByUserIdAndVersion(userId);
        return allNum % (userRewardNum = this.activityProperties.getInviteUserRewardNum().intValue()) == 0 ? 0 : userRewardNum - allNum % userRewardNum;
    }

    public LoginRewardFacadeDTO loginRewardInfo(Long userId) {
        return this.temporaryActivityService.loginRewardInfo(userId);
    }

    public Integer getUserLotteryNum(Long userId) {
        return this.userLotteryCacheManager.getUserLotteryNum(userId);
    }
}

