/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.facade.ActivityWithdrawFacadeService;
import com.bxm.fossicker.activity.facade.model.ActivityWithdrawDto;
import com.bxm.fossicker.activity.facade.model.ActivityWithdrawNewDto;
import com.bxm.fossicker.activity.model.vo.ActivityWithdraw;
import com.bxm.fossicker.activity.service.WithdrawService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityWithdrawFacadeServiceImpl
implements ActivityWithdrawFacadeService {
    @Autowired
    private WithdrawService withdrawService;
    @Autowired
    private ActivityProperties activityProperties;

    public List<ActivityWithdrawDto> list(Long userId) {
        return this.withdrawService.listByUserId(userId).stream().map(this::convert).collect(Collectors.toList());
    }

    private ActivityWithdrawDto convert(ActivityWithdraw activityWithdraw) {
        return ActivityWithdrawDto.builder().id(activityWithdraw.getId()).exceeTime(activityWithdraw.getExceeTime()).amount(this.activityProperties.getWithdrawType().get(activityWithdraw.getType().toString())).build();
    }

    public List<ActivityWithdrawNewDto> list(Long userId, Integer type) {
        return this.withdrawService.listByType(userId, type).stream().map(this::converts).collect(Collectors.toList());
    }

    private ActivityWithdrawNewDto converts(ActivityWithdraw activityWithdraw) {
        return ActivityWithdrawNewDto.builder().id(activityWithdraw.getId()).exceeTime(activityWithdraw.getExceeTime()).type(activityWithdraw.getType()).status(activityWithdraw.getStatus()).userId(activityWithdraw.getUserId()).build();
    }

    public void used(Long userId) {
        this.withdrawService.used(userId);
    }

    public void used(Long userId, Long id, Integer type) {
        this.withdrawService.used(userId, id, type);
    }
}

