/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.model.dto.FriendsInviteInfoDTO;
import com.bxm.fossicker.activity.model.dto.FriendsInviteProgressDTO;
import com.bxm.fossicker.activity.model.dto.InviteUserBaseInfoDTO;
import com.bxm.fossicker.activity.model.dto.TotalFriendsInfoDTO;
import com.bxm.fossicker.activity.model.param.FriendsListParam;
import com.bxm.fossicker.activity.model.vo.UserInviteRelation;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.activity.service.friends.FriendsInfoService;
import com.bxm.fossicker.activity.service.invite.InviteRelationService;
import com.bxm.fossicker.user.facade.CashFacadeService;
import com.bxm.fossicker.user.facade.GoldFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.enums.VipTypeEnum;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.fossicker.user.model.dto.CashFlowDto;
import com.bxm.fossicker.user.model.dto.GoldFlowDto;
import com.bxm.fossicker.user.model.param.FlowPageParam;
import com.bxm.fossicker.vo.PageWarper;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.github.pagehelper.Page;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FriendsInfoServiceImpl
implements FriendsInfoService {
    @Autowired
    @Lazy
    private InviteRelationService inviteRelationService;
    @Autowired
    private ActivityProperties activityProperties;
    @Autowired
    private VipFacadeService vipFacadeService;
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private GoldFacadeService goldFacadeService;
    @Autowired
    private CashFacadeService cashFacadeService;

    @Override
    public TotalFriendsInfoDTO getTotalFriendsInfo(Long userId) {
        Integer totalFriends = this.inviteRelationService.getFriendsNum(userId);
        BigDecimal earning = this.inviteRelationService.getEarning(userId);
        return TotalFriendsInfoDTO.builder().friendNum(totalFriends).earnings(Double.valueOf(Objects.isNull(earning) ? 0.0 : earning.doubleValue())).totalEarnings(Double.valueOf((double)totalFriends.intValue() * 25.0)).build();
    }

    @Override
    public FriendsInviteProgressDTO getInvitation(Long userId) {
        Integer friendsNum = this.inviteRelationService.getFriendsNumByVersion(userId);
        if (null == friendsNum || 0 == friendsNum) {
            return null;
        }
        return FriendsInviteProgressDTO.builder().friendNum(friendsNum).vipCardNum(this.vipFacadeService.getVipCardByInvite(userId)).userProcessInfo(this.getUserProcessInfo(friendsNum, userId)).build();
    }

    @Override
    public PageWarper<FriendsInviteInfoDTO> getFriendsList(FriendsListParam friendsListParam) {
        PageWarper resultPage = new PageWarper();
        resultPage.setPageNum(friendsListParam.getPageNum().intValue());
        resultPage.setPageSize(friendsListParam.getPageSize().intValue());
        Page<UserInviteRelation> friendsListPage = this.inviteRelationService.getAllFriendsList(friendsListParam);
        if (CollectionUtils.isEmpty((Collection)friendsListPage.getResult())) {
            return resultPage;
        }
        Map<Long, UserInfoDto> userInfoDtoMap = this.fillUserExtInfo(friendsListPage.getResult());
        List resultList = friendsListPage.stream().map(e -> this.convertAllFriends((UserInviteRelation)e, userInfoDtoMap)).collect(Collectors.toList());
        resultPage.setList(resultList);
        return resultPage;
    }

    private Map<Long, UserInfoDto> fillUserExtInfo(List<UserInviteRelation> resultList) {
        List userInfoDtoList = this.userInfoFacadeService.getUserByIds(resultList.stream().map(UserInviteRelation::getInvitedId).collect(Collectors.toList()));
        Map<Long, UserInfoDto> userInfoDtoMap = userInfoDtoList.stream().collect(Collectors.toMap(UserInfoDto::getId, Function.identity(), (key1, key2) -> key2));
        resultList.forEach(e -> {
            UserInfoDto userInfoDto = (UserInfoDto)userInfoDtoMap.get(e.getInvitedId());
            if (Objects.nonNull(userInfoDto)) {
                if (StringUtils.isNotBlank((CharSequence)userInfoDto.getNickName())) {
                    e.setInvitedName(userInfoDto.getNickName());
                }
                if (StringUtils.isNotBlank((CharSequence)userInfoDto.getHeadImg())) {
                    e.setInvitedHeadImg(userInfoDto.getHeadImg());
                }
            }
        });
        return userInfoDtoMap;
    }

    private List<InviteUserBaseInfoDTO> getUserProcessInfo(Integer friendsNum, Long userId) {
        ArrayList<InviteUserBaseInfoDTO> resultList = new ArrayList<InviteUserBaseInfoDTO>();
        if (null == friendsNum || 0 == friendsNum) {
            return resultList;
        }
        int validNum = friendsNum % this.activityProperties.getInviteUserRewardNum();
        if (0 == validNum) {
            return resultList;
        }
        List<UserInviteRelation> friendsList = this.inviteRelationService.getFriendsList(userId);
        if (CollectionUtils.isEmpty(friendsList)) {
            return resultList;
        }
        return friendsList.subList(0, validNum).stream().sorted(Comparator.comparing(UserInviteRelation::getInviteSuccessTime)).map(this::convert).collect(Collectors.toList());
    }

    private InviteUserBaseInfoDTO convert(UserInviteRelation userInviteRelation) {
        InviteUserBaseInfoDTO resultInfo = InviteUserBaseInfoDTO.builder().userId(userInviteRelation.getInvitedId()).headImg(userInviteRelation.getInvitedHeadImg()).build();
        UserInfoDto invitedUserInfo = this.userInfoFacadeService.getUserById(userInviteRelation.getInvitedId());
        if (Objects.nonNull(invitedUserInfo) && StringUtils.isNotBlank((CharSequence)invitedUserInfo.getHeadImg())) {
            resultInfo.setHeadImg(invitedUserInfo.getHeadImg());
        }
        return resultInfo;
    }

    private FriendsInviteInfoDTO convertAllFriends(UserInviteRelation userInviteRelation, Map<Long, UserInfoDto> userInfoDtoMap) {
        Integer vipCardNum;
        FriendsInviteInfoDTO friendsInviteInfoDTO = FriendsInviteInfoDTO.builder().headImg(userInviteRelation.getInvitedHeadImg()).goldEarnings(userInviteRelation.getGoldEarnings()).inviteType(userInviteRelation.getInviteType()).nickName(userInviteRelation.getInvitedName()).phoneNum(this.hidePhoneInfo(userInviteRelation.getInvitedPhone())).earnings(Double.valueOf(userInviteRelation.getInviteEarning().doubleValue())).inviteSuccessTime(DateUtils.formatAtWill((Date)userInviteRelation.getInviteSuccessTime(), (String)"yyyy/MM/dd")).loginSuccessFlag(Boolean.valueOf(false)).inviteSuccessFlag(Boolean.valueOf(1 == userInviteRelation.getStatus() || 0 == userInviteRelation.getStatus())).build();
        UserInfoDto invitedUserInfo = userInfoDtoMap.get(userInviteRelation.getInvitedId());
        if (Objects.nonNull(invitedUserInfo)) {
            friendsInviteInfoDTO.setUserId(userInviteRelation.getInvitedId());
            if (StringUtils.isNotBlank((CharSequence)invitedUserInfo.getHeadImg())) {
                friendsInviteInfoDTO.setHeadImg(invitedUserInfo.getHeadImg());
            }
            if (StringUtils.isNotBlank((CharSequence)invitedUserInfo.getNickName())) {
                friendsInviteInfoDTO.setNickName(invitedUserInfo.getNickName());
            }
            friendsInviteInfoDTO.setLoginSuccessFlag(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)invitedUserInfo.getWechatNickName()) && StringUtils.isNotBlank((CharSequence)invitedUserInfo.getTaobaoNickName())));
            if (VipTypeEnum.isUsable((byte)((byte)invitedUserInfo.getVip()))) {
                friendsInviteInfoDTO.setDesc("\u63d0\u9192\u597d\u53cb\u8d5a\u73b0\u91d1\uff0c\u4eab10%\u597d\u53cb\u6536\u5165\u5206\u6210");
            } else {
                friendsInviteInfoDTO.setDesc("\u63d0\u9192\u597d\u53cb\u5f00\u901a\u9ed1\u94bb\u5361\uff0c\u5f975\u5143\u73b0\u91d1\u5956\u52b1");
            }
        }
        if (Objects.isNull(vipCardNum = this.vipFacadeService.getTotalVipCard(userInviteRelation.getInvitedId())) || 0 == vipCardNum) {
            friendsInviteInfoDTO.setVipSuccessFlag(Boolean.valueOf(false));
            return friendsInviteInfoDTO;
        }
        friendsInviteInfoDTO.setVipSuccessFlag(Boolean.valueOf(true));
        friendsInviteInfoDTO.setVipCardNum(vipCardNum);
        return friendsInviteInfoDTO;
    }

    private String hidePhoneInfo(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return phone;
        }
        return phone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    @Override
    public List<GoldFlowDto> getFriendGoldFlow(FlowPageParam param) {
        return this.goldFacadeService.getFriendGoldFlow(param);
    }

    @Override
    public List<CashFlowDto> getFriendCashFlow(FlowPageParam param) {
        return this.cashFacadeService.getFriendCashFlow(param);
    }
}

