/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.facade.Taoqi365ParseUrlFacadeService;
import com.bxm.fossicker.activity.service.Taoqi365ParseUrlService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Taoqi365ParseUrlServiceImpl
implements Taoqi365ParseUrlService,
Taoqi365ParseUrlFacadeService {
    @Autowired
    ActivityProperties activityProperties;

    @Override
    public String parseUrl(String sourceUrl, String identify, String agentId) {
        if (StringUtils.isBlank((CharSequence)sourceUrl)) {
            return sourceUrl;
        }
        sourceUrl = sourceUrl.contains("?") ? sourceUrl + "&" : sourceUrl + "?";
        sourceUrl = sourceUrl + "machineCode=" + identify;
        sourceUrl = sourceUrl + "&agentId=" + agentId;
        sourceUrl = sourceUrl + "&timestamp=" + System.currentTimeMillis();
        List paramList = URLEncodedUtils.parse((String)StringUtils.substring((String)sourceUrl, (int)(sourceUrl.indexOf("?") + 1)), (Charset)StandardCharsets.UTF_8);
        paramList = paramList.stream().sorted(Comparator.comparing(NameValuePair::getName)).collect(Collectors.toList());
        StringBuilder signSource = new StringBuilder();
        for (NameValuePair nameValuePair : paramList) {
            if (StringUtils.equalsAny((CharSequence)nameValuePair.getName(), (CharSequence[])this.activityProperties.getExcludeParam())) continue;
            signSource.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue());
            signSource.append("&");
        }
        signSource.append("secretKey").append("=").append(this.activityProperties.getTaoqi365SecertKey());
        sourceUrl = sourceUrl + "&sign=" + MD5Util.hgmd5((String)signSource.toString()).toUpperCase();
        return sourceUrl;
    }
}

