/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.facade.model.LoginRewardFacadeDTO;
import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.param.ActivitiesParam;
import com.bxm.fossicker.activity.model.param.UserIdParam;
import com.bxm.fossicker.activity.model.vo.TemporaryActivityVO;
import com.bxm.fossicker.activity.service.TemporaryActivityService;
import com.bxm.fossicker.activity.service.config.TempActivityProperties;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.text.DateFormat;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemporaryActivityServiceImpl
implements TemporaryActivityService {
    private static final Logger log = LoggerFactory.getLogger(TemporaryActivityServiceImpl.class);
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private DistributedLock lock;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private AccountFacadeService accountFacadeService;
    @Autowired
    private TempActivityProperties tempActivityProperties;

    @Override
    public TemporaryActivityVO activities(ActivitiesParam param) {
        UserInfoDto userInfoDto;
        TemporaryActivityVO temporaryActivity = TemporaryActivityVO.builder().claimedPacket(Boolean.FALSE).build();
        if (null != param.getUserId() && null != (userInfoDto = this.userInfoFacadeService.getUserById(param.getUserId()))) {
            temporaryActivity.setClaimedPacket(userInfoDto.getClaimedPacket());
        }
        return temporaryActivity;
    }

    @Override
    public Message loginReward(UserIdParam param) {
        String subKey;
        if (Objects.isNull(param)) {
            return Message.build((boolean)false).setMessage("\u53c2\u6570\u9519\u8bef");
        }
        if (!this.lock.lock(ActivityRedisKey.LOGIN_REWARD_LOCK.copy().appendKey((Object)Objects.toString(param.getUserId())).gen(), this.sequenceCreater.nextStringId())) {
            return Message.build((boolean)false).setMessage("\u9886\u53d6\u767b\u5f55\u5956\u52b1\u8fc7\u4e8e\u9891\u7e41");
        }
        KeyGenerator key = ActivityRedisKey.LOGIN_REWARD.copy().appendKey((Object)((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
        String res = (String)this.redisHashMapAdapter.get(key, subKey = Objects.toString(param.getUserId()), String.class);
        if (StringUtils.isNotBlank((CharSequence)res)) {
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237: {} \u5df2\u9886\u53d6\u8fc7\u767b\u5f55\u5956\u52b1", (Object)param.getUserId());
            }
            return Message.build((boolean)false).setMessage("\u8bf7\u52ff\u91cd\u590d\u9886\u53d6");
        }
        this.redisHashMapAdapter.put(key, subKey, (Object)"1");
        this.redisHashMapAdapter.expire(key, (long)DateUtils.getCurSeconds());
        Message message = this.accountFacadeService.goldRebate(GoldRebateParam.builder().userId(param.getUserId()).userGoldFlowType(UserGoldFlowTypeEnum.LOGIN_REWARD).relationId(null).amount(this.tempActivityProperties.getLoginReward()).build());
        if (!message.isSuccess()) {
            log.warn("\u9886\u53d6\u767b\u5f55\u5956\u52b1\uff0c\u8d26\u6237\u6dfb\u52a0\u91d1\u989d\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f: {}", (Object)message.getLastMessage());
        }
        return Message.build();
    }

    @Override
    public LoginRewardFacadeDTO loginRewardInfo(Long userId) {
        if (Objects.nonNull(userId)) {
            KeyGenerator key = ActivityRedisKey.LOGIN_REWARD.copy().appendKey((Object)((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
            String res = (String)this.redisHashMapAdapter.get(key, Objects.toString(userId), String.class);
            LoginRewardFacadeDTO facadeDTO = new LoginRewardFacadeDTO();
            facadeDTO.setReward(this.tempActivityProperties.getLoginReward());
            facadeDTO.setGot(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)res)));
            return facadeDTO;
        }
        return null;
    }
}

