/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.domain.ActivityWithdrawMapper;
import com.bxm.fossicker.activity.model.vo.ActivityWithdraw;
import com.bxm.fossicker.activity.service.WithdrawService;
import com.bxm.fossicker.activity.service.sign.ActivitySignService;
import com.bxm.fossicker.enums.WithdrawTypeEnum;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class WithdrawServiceImpl
implements WithdrawService {
    private static final Logger log = LogManager.getLogger(WithdrawServiceImpl.class);
    @Autowired
    private ActivityWithdrawMapper withdrawMapper;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private ActivitySignService activitySignService;

    @Override
    public List<ActivityWithdraw> listByUserId(Long userId) {
        if (log.isDebugEnabled()) {
            log.debug("\u6839\u636e\u7528\u6237id\u83b7\u53d6\u672a\u8fc7\u671f\u53ef\u7528\u6d3b\u52a8\u63d0\u73b0,userId:[{}]", (Object)userId);
        }
        List withdraws = this.withdrawMapper.selectByUserId(userId);
        return withdraws.stream().filter(p -> p.getStatus().intValue() == 0).collect(Collectors.toList());
    }

    @Override
    public List<ActivityWithdraw> listByType(Long userId, Integer type) {
        if (log.isDebugEnabled()) {
            log.debug("1.4.1 \u7248\u672c \u6839\u636e\u7528\u6237id\u83b7\u53d6\u672a\u8fc7\u671f\u53ef\u7528\u6d3b\u52a8\u63d0\u73b0,userId:[{}]", (Object)userId);
        }
        return this.withdrawMapper.selectByType(userId, type);
    }

    @Override
    @Async
    public void add(Long userId, WithdrawTypeEnum withdrawTypeEnum) {
        if (log.isDebugEnabled()) {
            log.debug("\u6dfb\u52a0\u6d3b\u52a8\u63d0\u73b0,userId:[{}],type:[{}]", (Object)userId, (Object)withdrawTypeEnum.ordinal());
        }
        this.withdrawMapper.insertSelective(ActivityWithdraw.builder().id(this.sequenceCreater.nextLongId()).userId(userId).type(Byte.valueOf((byte)withdrawTypeEnum.ordinal())).build());
    }

    @Async
    public void add(Long userId, Integer type) {
        if (log.isDebugEnabled()) {
            log.debug("\u6dfb\u52a0\u6d3b\u52a8\u63d0\u73b0,userId:[{}],type:[{}]", (Object)userId, (Object)type);
        }
        this.withdrawMapper.insertSelective(ActivityWithdraw.builder().id(this.sequenceCreater.nextLongId()).userId(userId).type(Byte.valueOf((byte)type.intValue())).build());
    }

    @Override
    public void used(Long userId) {
        if (log.isDebugEnabled()) {
            log.debug("\u4f7f\u7528\u6389\u6d3b\u52a8\u63d0\u73b0\u673a\u4f1a\uff0c\u66f4\u65b0\u72b6\u6001,userId:[{}]", (Object)userId);
        }
        this.withdrawMapper.updateByUserId(userId);
        this.activitySignService.usedChance(userId);
    }

    @Override
    public void used(Long userId, Long id, Integer type) {
        if (log.isDebugEnabled()) {
            log.debug("\u4f7f\u7528\u6389\u6d3b\u52a8\u63d0\u73b0\u673a\u4f1a\uff0c\u66f4\u65b0\u72b6\u6001,userId:[{}]\uff0cid:{},type : {}", (Object)userId, (Object)id, (Object)type);
        }
        this.withdrawMapper.updateStatusByUserIdAndType(userId, id, type);
    }
}

