/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.invite.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.domain.UserInviteRelationMapper;
import com.bxm.fossicker.activity.facade.enums.InviteTypeEnum;
import com.bxm.fossicker.activity.facade.model.UserInviteRelationDTO;
import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.param.FriendsListParam;
import com.bxm.fossicker.activity.model.vo.UserInviteRelation;
import com.bxm.fossicker.activity.model.vo.UserInvitedVo;
import com.bxm.fossicker.activity.service.WithdrawService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.activity.service.invite.InviteRelationService;
import com.bxm.fossicker.activity.service.task.TaskService;
import com.bxm.fossicker.enums.TaskEnum;
import com.bxm.fossicker.order.integration.PushMessageIntegrationService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.enums.CashTypeDetail;
import com.bxm.fossicker.user.facade.param.CashIncrementParam;
import com.bxm.fossicker.user.facade.param.TobeVipParam;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InviteRelationServiceImpl
implements InviteRelationService {
    private static final Logger log = LogManager.getLogger(InviteRelationServiceImpl.class);
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private UserInviteRelationMapper userInviteRelationMapper;
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private AccountFacadeService accountFacadeService;
    @Autowired
    private ActivityProperties activityProperties;
    @Autowired
    private VipFacadeService vipFacadeService;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private PushMessageIntegrationService pushMessageIntegrationService;
    @Autowired
    private WithdrawService withdrawService;
    private TaskService taskService;

    private TaskService getTaskService() {
        if (Objects.isNull(this.taskService)) {
            this.taskService = (TaskService)SpringContextHolder.getBean(TaskService.class);
        }
        return this.taskService;
    }

    @Override
    public Boolean hasInviteRelation(Long userId) {
        return this.userInviteRelationMapper.countByInvitedId(userId) > 0;
    }

    @Override
    public Boolean addRelation(Long userId, Long invitedUserId) {
        UserInfoDto userInfo = this.userInfoFacadeService.getUserById(invitedUserId);
        return null != userInfo && this.userInfoFacadeService.setSuperior(invitedUserId, userId) != false && this.userInviteRelationMapper.addOne(this.build(userId, userInfo, true)) != false;
    }

    @Override
    public Boolean addRelationByPhone(Long userId, String phoneNo) {
        UserInfoDto invitedUserInfo = this.userInfoFacadeService.getUserForPhone(phoneNo);
        if (null == invitedUserInfo) {
            log.error("\u5efa\u7acb\u9080\u8bf7\u5173\u7cfb(\u624b\u673a\u53f7),\u67e5\u8be2\u88ab\u9080\u8bf7\u8005\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a,\u624b\u673a\u53f7\u4e3a:{}", (Object)phoneNo);
            return false;
        }
        if (null != this.userInviteRelationMapper.selectByInvitedUserId(invitedUserInfo.getId())) {
            log.error("\u5efa\u7acb\u9080\u8bf7\u5173\u7cfb(\u624b\u673a\u53f7),\u5df2\u6709\u9080\u8bf7\u5173\u7cfb,\u624b\u673a\u53f7\u4e3a:{}", (Object)phoneNo);
            return false;
        }
        this.userInviteRelationMapper.addOne(this.build(userId, invitedUserInfo, false));
        return true;
    }

    @Override
    @Transactional
    public Boolean bindRelation(Long userId, Long superiorUserId) {
        UserInfoDto userInfo = this.userInfoFacadeService.getUserById(userId);
        return this.hasInviteRelation(userId) != false ? Boolean.FALSE : this.userInviteRelationMapper.addOne(this.build(superiorUserId, userInfo, true));
    }

    @Override
    @Transactional
    public Boolean bindSuccessRelation(Long userId, Long superiorUserId, String currVer) {
        log.info("\u7ed1\u5b9a\u9080\u8bf7\u5173\u7cfb: userId: {} superiorUserId: {}", (Object)userId, (Object)superiorUserId);
        if (Objects.isNull(userId) || Objects.isNull(superiorUserId) || 0L == userId || 0L == superiorUserId) {
            log.warn("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a:{},{}", (Object)userId, (Object)superiorUserId);
            return false;
        }
        UserInfoDto userInfo = this.userInfoFacadeService.getUserById(userId);
        if (this.hasInviteRelation(userId).booleanValue()) {
            log.warn("\u7528\u6237:{}\u5df2\u6709\u9080\u8bf7\u5173\u7cfb", (Object)userId);
            return false;
        }
        if (Objects.isNull(this.userInviteRelationMapper.selectByInvitedIdAndStatus(userId))) {
            this.userInviteRelationMapper.addOne(this.build(superiorUserId, userInfo, false));
        }
        this.userInfoFacadeService.setSuperior(userId, superiorUserId);
        this.pushPopUpInfo(superiorUserId);
        this.pushMessageIntegrationService.pushHasFriendAcceptInvite(superiorUserId);
        this.getTaskService().taskComplete(userId, TaskEnum.INPUT_INVITE.name());
        if (com.bxm.newidea.component.tools.StringUtils.isGrateOrEqualThan((String)currVer, (String)"2.2.2")) {
            this.redisHashMapAdapter.increment(this.getNewVersionInviteUserKey(), userId.toString(), 1);
        }
        return true;
    }

    private KeyGenerator getNewVersionInviteUserKey() {
        return ActivityRedisKey.NEW_VERSION_INVITE_USER_KEY;
    }

    @Override
    public List<UserInvitedVo> getInvitedList(Long userId) {
        return this.userInviteRelationMapper.queryInvitedByUserId(userId);
    }

    @Override
    public Boolean updateRemind(Long userId, Long invitedId) {
        return this.userInviteRelationMapper.updateRemindStatus(userId, invitedId) > 0;
    }

    @Override
    @Async
    public void initRemindStatus() {
        this.userInviteRelationMapper.initRemindStatus();
    }

    @Override
    public Integer getFriendsNum(Long userId) {
        return this.userInviteRelationMapper.selectFriendsNumByUserId(userId);
    }

    @Override
    public BigDecimal getEarning(Long userId) {
        return this.userInviteRelationMapper.getEarning(userId);
    }

    @Override
    public Integer getFriendsNumByVersion(Long userId) {
        return this.userInviteRelationMapper.selectFriendsNumByUserIdAndVersion(userId);
    }

    @Override
    public List<UserInviteRelation> getFriendsList(Long userId) {
        return this.userInviteRelationMapper.getFriendsListInfo(userId);
    }

    @Override
    public Page<UserInviteRelation> getAllFriendsList(FriendsListParam friendsListParam) {
        return PageHelper.startPage((Object)friendsListParam).doSelectPage(() -> this.userInviteRelationMapper.getAllFriendsListInfo(friendsListParam));
    }

    @Override
    public Boolean rewardOldFriends() {
        List oldRelationList = this.userInviteRelationMapper.selectOldFriends();
        if (CollectionUtils.isEmpty((Collection)oldRelationList)) {
            log.error("\u5956\u52b1\u8001\u7528\u6237\u7684\u540d\u5355\u4e3a\u7a7a");
            return false;
        }
        HashMap<Long, Integer> pushUserIdMap = new HashMap<Long, Integer>(oldRelationList.size());
        oldRelationList.forEach(userInviteRelation -> {
            Long userId = userInviteRelation.getUserId();
            this.rewardOldRelation((UserInviteRelation)userInviteRelation);
            Integer friendsNum = (Integer)pushUserIdMap.get(userId);
            if (Objects.isNull(friendsNum)) {
                pushUserIdMap.put(userId, 1);
            } else {
                pushUserIdMap.put(userId, friendsNum + 1);
            }
        });
        pushUserIdMap.forEach((key, value) -> {
            try {
                this.pushMessageIntegrationService.pushNewVersionPush(key, value);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u6570\u636e\u5f02\u5e38:{}", (Throwable)e);
            }
        });
        return true;
    }

    @Override
    public Integer getSuccessInvitationInfo(Long userId) {
        if (Objects.isNull(userId)) {
            log.error("\u83b7\u53d6\u6210\u529f\u9080\u8bf7\u597d\u53cb\u6570,\u7528\u6237id\u4e3anull");
        }
        KeyGenerator inviteUserMapKey = this.getInviteUserKey();
        this.getNewVersionSuccessInviteNum(userId);
        return this.redisHashMapAdapter.getLong(inviteUserMapKey, userId.toString()).intValue();
    }

    @Override
    public Boolean removeSuccessInvitation(Long userId) {
        if (Objects.isNull(userId)) {
            log.error("\u5220\u9664\u6210\u529f\u9080\u8bf7\u597d\u53cb\u6570,\u7528\u6237id\u4e3anull");
        }
        KeyGenerator inviteUserMapKey = this.getInviteUserKey();
        this.removeNewVersionInviteNum(userId);
        this.redisHashMapAdapter.remove(inviteUserMapKey, new String[]{userId.toString()});
        return true;
    }

    @Override
    public Boolean addOldRelation() {
        List oldRelationUserList = this.userInfoFacadeService.getOldRelationUser();
        if (CollectionUtils.isEmpty((Collection)oldRelationUserList)) {
            return false;
        }
        oldRelationUserList.forEach(this::addOldRelation);
        return true;
    }

    @Override
    public Boolean updateRewardVip(Long userId, Long invitedId, BigDecimal rewardAmt) {
        this.userInviteRelationMapper.rewardVip(userId, invitedId, rewardAmt, null);
        return true;
    }

    @Override
    public Boolean updateGoldRewardVip(Long userId, Long invitedId, Integer rewardAmt) {
        this.userInviteRelationMapper.rewardVip(userId, invitedId, null, rewardAmt);
        return true;
    }

    private UserInviteRelation build(Long userId, UserInfoDto userInfo, boolean sucBind) {
        Date current = new Date();
        return UserInviteRelation.builder().id(this.sequenceCreater.nextLongId()).userId(userId).invitedPhone(userInfo.getPhoneno()).status(Integer.valueOf(sucBind ? 1 : 0)).invitedId(userInfo.getId()).invitedName(userInfo.getNickName()).invitedHeadImg(userInfo.getHeadImg()).remindStatus(Integer.valueOf(0)).inviteVersion(Integer.valueOf(1)).createTime(current).modifyTime(current).inviteSuccessTime(current).build();
    }

    @Override
    public Message inviteFinalSuccess(Long invitedId, Long userId) {
        log.info("\u4e0b\u53d1\u9080\u8bf7\u5956\u52b1 \u9080\u8bf7\u4eba: [{}] \u88ab\u9080\u8bf7\u4eba: [{}]", (Object)userId, (Object)invitedId);
        this.userInviteRelationMapper.updateBindStatus(userId, invitedId);
        this.rewardInviteForLogin(userId, invitedId);
        this.rewardInviteForVip(userId, invitedId);
        return Message.build();
    }

    @Override
    public Message updateInviteType(Long userId, Long invitedId, InviteTypeEnum inviteTypeEnum) {
        this.userInviteRelationMapper.updateInviteType(userId, invitedId, inviteTypeEnum.name());
        return Message.build((boolean)true);
    }

    @Override
    public UserInviteRelationDTO getFirstSuccessCashInviteRelationInfo(Long userId) {
        return this.convert(this.userInviteRelationMapper.getFirstSuccessCashInviteRelationInfo(userId));
    }

    private UserInviteRelationDTO convert(UserInviteRelation relation) {
        if (Objects.isNull(relation)) {
            return null;
        }
        UserInviteRelationDTO relationDTO = new UserInviteRelationDTO();
        BeanUtils.copyProperties((Object)relation, (Object)relationDTO);
        return relationDTO;
    }

    @Override
    public Message inviteFinalSuccessForV2(Long invitedId, Long userId) {
        log.info("\u4e0b\u53d1\u9080\u8bf7\u5956\u52b1 \u9080\u8bf7\u4eba: [{}] \u88ab\u9080\u8bf7\u4eba: [{}]", (Object)userId, (Object)invitedId);
        this.userInviteRelationMapper.updateBindStatus(userId, invitedId);
        return Message.build();
    }

    private boolean rewardInviteForLogin(Long userId, Long invitedId) {
        KeyGenerator loginRewardKey = ActivityRedisKey.HAVA_REWARD_LOGIN_INVITE;
        TypeReference<List<Long>> typeReference = new TypeReference<List<Long>>(){};
        ArrayList<Long> invitedIdList = (ArrayList<Long>)this.redisHashMapAdapter.get(loginRewardKey, userId.toString(), (TypeReference)typeReference);
        if (!CollectionUtils.isEmpty((Collection)invitedIdList) && invitedIdList.contains(invitedId)) {
            log.warn("\u8be5\u7528\u6237:{}\u5df2\u7ecf\u83b7\u53d6\u6b64\u7528\u6237:{} \u7684\u9080\u8bf7\u5956\u52b1,\u4e0d\u518d\u53d1\u653e\u5956\u52b1", (Object)userId, (Object)invitedId);
            return false;
        }
        UserInviteRelation userInviteRelation = this.userInviteRelationMapper.selectByUserAndInvitedId(userId, invitedId);
        if (Objects.isNull(userInviteRelation)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u4fe9\u7528\u6237\u7684\u9080\u8bf7\u5173\u7cfb,\u9080\u8bf7\u4eba:{}, \u88ab\u9080\u8bf7\u4eba:{}", (Object)userId, (Object)invitedId);
            return false;
        }
        BigDecimal inviteUserReward = new BigDecimal(this.activityProperties.getInviteUserReward());
        this.userInviteRelationMapper.rewardLogin(userId, invitedId, inviteUserReward);
        CashIncrementParam cashIncrementParam = new CashIncrementParam(userId, inviteUserReward, invitedId, CashTypeDetail.INVITE_LOGIN);
        this.accountFacadeService.cashIncrement(cashIncrementParam);
        if (CollectionUtils.isEmpty((Collection)invitedIdList)) {
            invitedIdList = new ArrayList<Long>();
        }
        invitedIdList.add(invitedId);
        this.redisHashMapAdapter.put(loginRewardKey, userId.toString(), invitedIdList);
        return true;
    }

    private boolean rewardInviteForVip(Long userId, Long invitedId) {
        List rewardVipUserList = this.userInviteRelationMapper.getRewardVipUserList(userId);
        if (CollectionUtils.isEmpty(rewardVipUserList = rewardVipUserList.stream().filter(p -> {
            UserInfoDto user = this.userInfoFacadeService.getUserById(p.getInvitedId());
            if (Objects.nonNull(user)) {
                return StringUtils.isNotBlank((CharSequence)user.getWechatNickName()) && StringUtils.isNotBlank((CharSequence)user.getTaobaoNickName());
            }
            return false;
        }).collect(Collectors.toList())) || rewardVipUserList.size() < this.activityProperties.getInviteUserRewardNum()) {
            log.warn("\u7528\u6237:{}\u6240\u9080\u8bf7\u7684\u597d\u53cb\u6570\u672a\u8fbe\u5230\u89c4\u5b9a\u5956\u52b1vip\u6570,\u88ab\u9080\u8bf7\u7528\u6237:{}", (Object)userId, (Object)invitedId);
            return false;
        }
        ArrayList invitedUserIdList = new ArrayList();
        rewardVipUserList.subList(0, 3).forEach(userInviteRelation -> {
            this.userInviteRelationMapper.updateConsumeStatusById(userInviteRelation.getId());
            invitedUserIdList.add(userInviteRelation.getInvitedId());
        });
        TobeVipParam tobeVipParam = new TobeVipParam();
        tobeVipParam.setUserId(userId);
        tobeVipParam.setType(1);
        tobeVipParam.setRelationId(JSON.toJSONString(invitedUserIdList));
        if (!this.vipFacadeService.tobeVip(tobeVipParam)) {
            log.warn("\u521b\u5efa\u4f1a\u5458\u5931\u8d25,\u521b\u5efa\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)tobeVipParam));
            return false;
        }
        return true;
    }

    private boolean pushPopUpInfo(Long userId) {
        KeyGenerator inviteUserMapKey = this.getInviteUserKey();
        this.redisHashMapAdapter.increment(inviteUserMapKey, userId.toString(), 1);
        return true;
    }

    private KeyGenerator getInviteUserKey() {
        return ActivityRedisKey.INVITE_USER_MAP;
    }

    private boolean rewardOldRelation(UserInviteRelation userInviteRelation) {
        Long userId = userInviteRelation.getUserId();
        Long invitedUserId = userInviteRelation.getInvitedId();
        if (Objects.isNull(userId) || Objects.isNull(invitedUserId)) {
            log.error("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a:{},{}", (Object)userId, (Object)invitedUserId);
            return false;
        }
        this.rewardInviteForLogin(userId, invitedUserId);
        return true;
    }

    private boolean addOldRelation(UserInfoDto invitedUserInfo) {
        if (null == invitedUserInfo) {
            log.error("\u589e\u52a0\u8001\u7528\u6237\u9080\u8bf7\u5173\u7cfb,\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            return false;
        }
        if (null != this.userInviteRelationMapper.selectByInvitedUserId(invitedUserInfo.getId())) {
            log.error("\u589e\u52a0\u8001\u7528\u6237\u9080\u8bf7\u5173\u7cfb,\u5df2\u6709\u9080\u8bf7\u5173\u7cfb,\u7528\u6237id\u4e3a:{}", (Object)invitedUserInfo.getId());
            return false;
        }
        UserInviteRelation userInviteRelation = this.build(invitedUserInfo.getSuperiorUserId(), invitedUserInfo, false);
        userInviteRelation.setInviteVersion(Integer.valueOf(0));
        this.userInviteRelationMapper.addOne(userInviteRelation);
        return true;
    }

    @Override
    public Integer getNewVersionSuccessInviteNum(Long userId) {
        return this.redisHashMapAdapter.getLong(this.getNewVersionInviteUserKey(), userId.toString()).intValue();
    }

    private void removeNewVersionInviteNum(Long userId) {
        this.redisHashMapAdapter.remove(this.getNewVersionInviteUserKey(), new String[]{userId.toString()});
    }
}

