/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.invite.impl;

import com.bxm.fossicker.activity.config.InviteConfig;
import com.bxm.fossicker.activity.config.TaskConfig;
import com.bxm.fossicker.activity.domain.UserAddressListMapper;
import com.bxm.fossicker.activity.enums.RemindStatusEnum;
import com.bxm.fossicker.activity.facade.InviteFacadeService;
import com.bxm.fossicker.activity.facade.model.UserInviteRelationDTO;
import com.bxm.fossicker.activity.model.dto.InviteListDto;
import com.bxm.fossicker.activity.model.dto.InviteResultDTO;
import com.bxm.fossicker.activity.model.dto.InviterDto;
import com.bxm.fossicker.activity.model.param.BindInviteListParam;
import com.bxm.fossicker.activity.model.param.BindInviteParam;
import com.bxm.fossicker.activity.model.param.RemindParam;
import com.bxm.fossicker.activity.model.vo.UserAddressList;
import com.bxm.fossicker.activity.model.vo.UserInvitedVo;
import com.bxm.fossicker.activity.service.UserAddressListService;
import com.bxm.fossicker.activity.service.invite.InviteRelationService;
import com.bxm.fossicker.activity.service.invite.InviteService;
import com.bxm.fossicker.integration.commodity.service.BrowseFlowFacadeService;
import com.bxm.fossicker.message.enums.SmsTempEnum;
import com.bxm.fossicker.message.facade.SmsFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.InviteInfoDTO;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InviteServiceImpl
implements InviteService,
InviteFacadeService {
    private static final Logger log = LoggerFactory.getLogger(InviteServiceImpl.class);
    @Autowired
    private InviteRelationService inviteRelationService;
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private BrowseFlowFacadeService browseFlowFacadeService;
    @Autowired
    private TaskConfig taskConfig;
    @Autowired
    private InviteConfig inviteConfig;
    @Autowired
    private UserAddressListService userAddressListService;
    @Autowired
    private UserAddressListMapper userAddressListMapper;
    @Autowired
    private SmsFacadeService smsFacadeService;

    @Override
    public String getInviteCodeByUserId(Long userId) {
        UserInfoDto userInfo = this.userInfoFacadeService.getUserById(userId);
        if (null == userInfo) {
            log.error("\u7528\u6237[{}]\u9080\u8bf7\u7801\u4e0d\u5b58\u5728", (Object)userId);
            return "";
        }
        return userInfo.getInviteCode();
    }

    @Override
    public InviteInfoDTO getInviteInfoByUserId(Long userId) {
        return this.userInfoFacadeService.getInviteInfoByUserId(userId);
    }

    @Override
    public Boolean bindRelation(BindInviteParam bindInviteParam) {
        UserInfoDto user;
        if (Objects.isNull(bindInviteParam.getUserId()) || Objects.isNull(bindInviteParam.getInviteUserId())) {
            log.error("\u9080\u8bf7\u7801\u7ed1\u5b9a\u5173\u7cfb,\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a,\u9080\u8bf7\u4ebaid:{}, \u88ab\u9080\u8bf7\u4ebaid:{}", (Object)bindInviteParam.getInviteUserId(), (Object)bindInviteParam.getUserId());
            return Boolean.FALSE;
        }
        InviteResultDTO checkResult = this.checkInviteCode(bindInviteParam);
        if (null == checkResult || !checkResult.getSuccess().booleanValue()) {
            return false;
        }
        Boolean res = this.inviteRelationService.bindSuccessRelation(bindInviteParam.getUserId(), bindInviteParam.getInviteUserId(), bindInviteParam.getCurVer());
        if (res.booleanValue() && Objects.nonNull(user = this.userInfoFacadeService.getUserById(bindInviteParam.getUserId()))) {
            this.inviteRelationService.inviteFinalSuccessForV2(bindInviteParam.getUserId(), bindInviteParam.getInviteUserId());
        }
        return res;
    }

    @Override
    public InviteResultDTO checkInviteCode(BindInviteParam bindInviteParam) {
        if (Objects.equals(this.inviteConfig.getInviteCodeSwitch(), Boolean.FALSE)) {
            return new InviteResultDTO("\u7ed1\u5b9a\u5931\u8d25");
        }
        Long invitedUserId = bindInviteParam.getUserId();
        Long inviteUserId = bindInviteParam.getInviteUserId();
        if (Objects.isNull(invitedUserId)) {
            return new InviteResultDTO("\u7528\u6237id\u5fc5\u586b");
        }
        UserInfoDto userInfoDto = Objects.isNull(inviteUserId) ? this.userInfoFacadeService.getUserByInviteCodeOrPhone(bindInviteParam.getInputCode()) : this.userInfoFacadeService.getUserById(inviteUserId);
        if (Objects.isNull(userInfoDto) || Objects.isNull(userInfoDto.getId())) {
            log.warn("\u7528\u6237[{}]\u6821\u9a8c\u9080\u8bf7\u5173\u7cfb\u5931\u8d25,\u8be5\u9080\u8bf7\u7801\u65e0\u6548", (Object)bindInviteParam.getUserId());
            return new InviteResultDTO("\u9080\u8bf7\u7801\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        if (Objects.equals(invitedUserId, userInfoDto.getId())) {
            return new InviteResultDTO("\u4e0d\u53ef\u4ee5\u6210\u4e3a\u81ea\u5df1\u7684\u597d\u53cb");
        }
        if (invitedUserId.equals(userInfoDto.getSuperiorUserId()) || invitedUserId.equals(userInfoDto.getTopUserId())) {
            log.warn("\u7528\u6237[{}]\u9080\u8bf7\u7684\u9080\u8bf7\u4eba\u4e0d\u53ef\u4e3a\u597d\u53cb\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (Object)invitedUserId);
            return new InviteResultDTO("\u9080\u8bf7\u4eba\u4e0d\u53ef\u4e3a\u597d\u53cb\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        UserInfoDto invitedUserInfoDTO = this.userInfoFacadeService.getUserById(invitedUserId);
        if (Objects.isNull(invitedUserInfoDTO) || Objects.isNull(invitedUserInfoDTO.getId())) {
            return new InviteResultDTO("\u65e0\u88ab\u9080\u8bf7\u4eba\u4fe1\u606f");
        }
        if (Objects.nonNull(invitedUserInfoDTO.getSuperiorUserId())) {
            return new InviteResultDTO("\u4f60\u5df2\u6709\u9080\u8bf7\u4eba\uff0c\u4e0d\u53ef\u8f93\u5165");
        }
        return new InviteResultDTO(userInfoDto.getId(), userInfoDto.getNickName(), userInfoDto.getHeadImg());
    }

    @Override
    public Message rewardRemedy(String userIds) {
        if (StringUtils.isBlank((CharSequence)userIds)) {
            return Message.build((boolean)false).setMessage("\u53c2\u6570\u6709\u8bef");
        }
        Arrays.asList(userIds.split(",")).forEach(p -> {
            long id = Long.parseLong(p);
            UserInfoDto user = this.userInfoFacadeService.getUserById(Long.valueOf(id));
            if (Objects.nonNull(user) && Objects.nonNull(user.getSuperiorUserId())) {
                this.inviteRelationService.inviteFinalSuccessForV2(user.getId(), user.getSuperiorUserId());
            }
        });
        return Message.build();
    }

    @Override
    public boolean judgeVipFriendCashReward(Long userId) {
        return this.userInfoFacadeService.judgeVipFriendCashReward(userId);
    }

    @Override
    public InviteListDto getInvitedList(Long userId) {
        List<UserInvitedVo> userInvitedVoList;
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u59cb\u83b7\u53d6\u7528\u6237[{}]\u9080\u8bf7\u6210\u529f\u7684\u597d\u53cb\u4fe1\u606f", (Object)userId);
        }
        if (CollectionUtils.isEmpty(userInvitedVoList = this.inviteRelationService.getInvitedList(userId))) {
            return this.convertToEmptyDto();
        }
        List userIdList = userInvitedVoList.stream().map(UserInvitedVo::getUserId).collect(Collectors.toList());
        Map totalBrowseMap = this.browseFlowFacadeService.getTotalBrowseMap(userIdList);
        return this.convert(userInvitedVoList, totalBrowseMap);
    }

    private InviteListDto convert(List<UserInvitedVo> userInvitedVoList, Map<Long, Integer> browseCountVoMap) {
        ArrayList inviterDtoList = Lists.newArrayList();
        userInvitedVoList.forEach(userInvitedVo -> inviterDtoList.add(this.convert(browseCountVoMap, (UserInvitedVo)userInvitedVo)));
        return InviteListDto.builder().inviteCount(Integer.valueOf(userInvitedVoList.size())).totalAmount(String.valueOf(userInvitedVoList.size() * this.inviteConfig.getReward())).inviteDtoList((List)inviterDtoList).build();
    }

    private InviterDto convert(Map<Long, Integer> browseCountVoMap, UserInvitedVo userInvitedVo) {
        Integer totalBrowseCount = null == browseCountVoMap || null == browseCountVoMap.get(userInvitedVo.getUserId()) ? Integer.valueOf(0) : browseCountVoMap.get(userInvitedVo.getUserId());
        return InviterDto.builder().userId(userInvitedVo.getUserId()).phone(new StringBuffer(userInvitedVo.getInvitedPhone()).replace(3, 7, "****").toString()).browseCount(totalBrowseCount).contributeGold(this.calculateContributeGold(totalBrowseCount)).remind(Boolean.valueOf(userInvitedVo.getRemindStatus().equals(RemindStatusEnum.REMINDED.getCode()))).build();
    }

    private Integer calculateContributeGold(Integer totalBrowseCount) {
        if (totalBrowseCount >= 0 && totalBrowseCount <= 100) {
            return totalBrowseCount * this.taskConfig.getGoodsViewReward().intValue() * 8;
        }
        if (totalBrowseCount > 100 && totalBrowseCount <= 400) {
            return 100 * this.taskConfig.getGoodsViewReward().intValue() * 8 + (totalBrowseCount - 100) * this.taskConfig.getGoodsViewReward().intValue() * 3;
        }
        if (totalBrowseCount > 400 && totalBrowseCount <= 900) {
            return 100 * this.taskConfig.getGoodsViewReward().intValue() * 8 + 300 * this.taskConfig.getGoodsViewReward().intValue() * 3 + (totalBrowseCount - 400) * this.taskConfig.getGoodsViewReward().intValue() * 2;
        }
        return 100 * this.taskConfig.getGoodsViewReward().intValue() * 8 + 300 * this.taskConfig.getGoodsViewReward().intValue() * 3 + 500 * this.taskConfig.getGoodsViewReward().intValue() * 2 + (totalBrowseCount - 900) * this.taskConfig.getGoodsViewReward().intValue();
    }

    private InviteListDto convertToEmptyDto() {
        return InviteListDto.builder().inviteCount(Integer.valueOf(0)).totalAmount("0").inviteDtoList((List)Lists.newArrayList()).build();
    }

    @Override
    public Boolean remind(RemindParam remindParam) {
        UserInfoDto userInfoDto;
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237[{}]\u63d0\u9192\u88ab\u9080\u8bf7\u7528\u6237[{}]\u6d4f\u89c8\u5546\u54c1", (Object)remindParam.getUserId(), (Object)remindParam.getInvitedUserId());
        }
        if (this.inviteRelationService.updateRemind(remindParam.getUserId(), remindParam.getInvitedUserId()).booleanValue() && null != (userInfoDto = this.userInfoFacadeService.getUserById(remindParam.getInvitedUserId()))) {
            this.smsFacadeService.sendSms(userInfoDto.getPhoneno(), SmsTempEnum.REIMNDER_SMS, new Object[0]);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Message invite(BindInviteListParam bindInviteListParam) {
        UserInfoDto userInfoDto;
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u53d1\u9001\u9080\u8bf7\u77ed\u4fe1,data:[{}]", (Object)bindInviteListParam);
        }
        if (null != (userInfoDto = this.userInfoFacadeService.getUserByInviteCodeOrPhone(bindInviteListParam.getPhone()))) {
            log.error("\u624b\u673a\u53f7: [{}] \u5df2\u6ce8\u518c\u7528\u6237\uff0c\u65e0\u6cd5\u9080\u8bf7", (Object)bindInviteListParam.getPhone());
            return Message.build((boolean)false).setMessage("\u8be5\u53f7\u7801\u5df2\u6ce8\u518c");
        }
        if (null != bindInviteListParam.getId()) {
            if (!this.userAddressListService.invited(bindInviteListParam.getId()).booleanValue()) return Message.build((boolean)false).setMessage("\u9080\u8bf7\u5931\u8d25\uff0c\u8bf7\u52ff\u91cd\u590d\u9080\u8bf7");
            UserAddressList userAddressList = this.userAddressListMapper.selectByPrimaryKey(bindInviteListParam.getId());
            if (userAddressList == null) return Message.build((boolean)false).setMessage("\u9080\u8bf7\u5931\u8d25");
            bindInviteListParam.setPhone(userAddressList.getPhone());
            return this.sendInviteSms(bindInviteListParam);
        }
        if (!StringUtils.isNotBlank((CharSequence)bindInviteListParam.getPhone())) return Message.build((boolean)false).setMessage("\u9080\u8bf7\u5931\u8d25");
        if (!this.userAddressListService.invited(bindInviteListParam.getUserId(), bindInviteListParam.getPhone()).booleanValue()) return Message.build((boolean)false).setMessage("\u9080\u8bf7\u5931\u8d25\uff0c\u8bf7\u52ff\u91cd\u590d\u9080\u8bf7");
        return this.sendInviteSms(bindInviteListParam);
    }

    private Message sendInviteSms(BindInviteListParam bindInviteListParam) {
        return this.smsFacadeService.sendSms(bindInviteListParam.getPhone(), SmsTempEnum.RELATIVE_INVITE, new Object[]{bindInviteListParam.getUserId()});
    }

    @Override
    public List<String> scrollBar() {
        return this.inviteConfig.getMessage();
    }

    public Boolean addRelationBySms(Long userId, String phone) {
        if (Objects.isNull(userId)) {
            log.info("\u9080\u8bf7\u8005\u7528\u6237id\u4e3a\u7a7a,\u7528\u6237\u624b\u673a\u53f7\u4e3a:{}", (Object)phone);
            return false;
        }
        return this.inviteRelationService.addRelationByPhone(userId, phone);
    }

    public UserInviteRelationDTO getFirstSuccessCashInviteRelationInfo(Long userId) {
        return this.inviteRelationService.getFirstSuccessCashInviteRelationInfo(userId);
    }
}

