/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.rush.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.ActivityRushMapper;
import com.bxm.fossicker.activity.model.dto.RushActivityDTO;
import com.bxm.fossicker.activity.model.vo.ActivityRush;
import com.bxm.fossicker.activity.service.rush.RushActivityService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RushActivityServiceImpl
extends BaseService
implements RushActivityService {
    private static final Logger log = LoggerFactory.getLogger(RushActivityServiceImpl.class);
    private final ActivityRushMapper activityRushMapper;
    private final RedisStringAdapter redisStringAdapter;

    @Override
    public RushActivityDTO getRushActivity(Long id) {
        return this.get(id);
    }

    private RushActivityDTO get(Long id) {
        ActivityRush activityRush;
        RushActivityDTO rushActivityDTO = (RushActivityDTO)this.redisStringAdapter.get(ActivityRedisKeyConstant.RUSH_INFO_MAP_KEY.copy(), RushActivityDTO.class);
        if (null == rushActivityDTO && null != (activityRush = this.activityRushMapper.selectByPrimaryKey(id))) {
            rushActivityDTO = this.convert(activityRush);
            this.redisStringAdapter.set(ActivityRedisKeyConstant.RUSH_INFO_MAP_KEY.copy(), (Object)rushActivityDTO);
        }
        return rushActivityDTO;
    }

    @Override
    public List<ActivityRush> listActivityRush() {
        return this.activityRushMapper.listActivityRush();
    }

    @Override
    public Message updateOpenTime(ActivityRush activityRush) {
        this.activityRushMapper.updateOpenTime(activityRush);
        return Message.build((boolean)true);
    }

    @Override
    public Message updateStatus(ActivityRush activityRush) {
        this.activityRushMapper.updateStatus(activityRush);
        return Message.build((boolean)true);
    }

    private RushActivityDTO convert(ActivityRush activityRush) {
        return RushActivityDTO.builder().id(activityRush.getId()).title(activityRush.getTitle()).desc(activityRush.getDesc()).goodsName(activityRush.getGoodsName()).goodsImgUrl(JSONObject.parseArray((String)activityRush.getGoodsImgUrl(), String.class)).goodsPrice(activityRush.getGoodsPrice()).goodsNum(activityRush.getGoodsNum()).openTime(activityRush.getOpenTime()).endTime(activityRush.getEndTime()).status(activityRush.getStatus()).build();
    }

    @Autowired
    public RushActivityServiceImpl(ActivityRushMapper activityRushMapper, RedisStringAdapter redisStringAdapter) {
        this.activityRushMapper = activityRushMapper;
        this.redisStringAdapter = redisStringAdapter;
    }
}

