/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.task.action.impl;

import com.bxm.fossicker.activity.enums.TaskStatusEnum;
import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.service.task.action.ActivityTaskAction;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

public abstract class AbstractActivityDailyTaskAction
implements ActivityTaskAction {
    private static final Logger log = LoggerFactory.getLogger(AbstractActivityDailyTaskAction.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    protected RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private DistributedLock distributedLock;

    @Override
    public void complete(Long userId, String taskCode) {
        if (!this.extraCheckForComplete(userId)) {
            return;
        }
        String key = ActivityRedisKey.buildDailyTaskStatusKey((Long)userId).gen();
        this.redisTemplate.opsForHash().putIfAbsent((Object)key, (Object)taskCode, (Object)String.valueOf(TaskStatusEnum.FINISH_UNOBTAIN.getCode()));
        this.redisTemplate.expire((Object)key, (long)DateUtils.getCurSeconds(), TimeUnit.SECONDS);
    }

    protected abstract boolean extraCheckForComplete(Long var1);

    @Override
    public Boolean allowReward(Long userId, String taskCode) {
        String resource = StringUtils.join((Object[])new String[]{taskCode, Objects.toString(userId)});
        if (!this.distributedLock.lock(resource, userId.toString(), 2L, TimeUnit.SECONDS)) {
            log.warn("\u83b7\u53d6\u5956\u52b1\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u7528\u6237id: {}", (Object)userId);
            return false;
        }
        KeyGenerator key = ActivityRedisKey.buildDailyTaskStatusKey((Long)userId);
        String result = (String)this.redisHashMapAdapter.get(key, taskCode, String.class);
        if (StringUtils.isNotBlank((CharSequence)result) && Integer.valueOf(result).equals(TaskStatusEnum.FINISH_UNOBTAIN.getCode())) {
            this.redisHashMapAdapter.put(key, taskCode, (Object)TaskStatusEnum.OBTAINED.getCode());
            return true;
        }
        this.distributedLock.unlock(resource, userId.toString());
        return false;
    }
}

