/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.task.action.impl;

import com.bxm.fossicker.activity.constants.TaskConstant;
import com.bxm.fossicker.activity.domain.ActivityTaskMapper;
import com.bxm.fossicker.activity.enums.DisplayEnum;
import com.bxm.fossicker.activity.enums.TaskStatusEnum;
import com.bxm.fossicker.activity.model.vo.ActivityUserTask;
import com.bxm.fossicker.activity.service.task.NewUserActivityTaskService;
import com.bxm.fossicker.activity.service.task.action.ActivityTaskAction;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="new_user_task")
public class NewUserActivityTaskActionImpl
implements ActivityTaskAction {
    private static final Logger log = LogManager.getLogger(NewUserActivityTaskActionImpl.class);
    @Autowired
    private ActivityTaskMapper taskMapper;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private NewUserActivityTaskService newUserActivityTaskService;
    @Autowired
    private DistributedLock distributedLock;
    public static final String COMPLETE = "COMPLETE";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void complete(Long userId, String taskCode) {
        String key = StringUtils.join((Object[])new String[]{taskCode, COMPLETE, Objects.toString(userId)});
        if (!this.distributedLock.lock(key, userId.toString(), 2L, TimeUnit.SECONDS)) {
            log.warn("\u5b8c\u6210\u4efb\u52a1\u5206\u5e03\u5f0f\u9501\u83b7\u53d6\u5931\u8d25, userId: {} taskCode: {}", (Object)userId, (Object)taskCode);
            return;
        }
        Optional<ActivityUserTask> userTaskOptional = Optional.ofNullable(this.taskMapper.query(userId, taskCode));
        if (userTaskOptional.isPresent()) {
            if (userTaskOptional.get().getStatus().equals(TaskStatusEnum.UNFINISHED.getCode())) {
                this.updateComplete(userTaskOptional.get().getId());
            }
        } else {
            this.addComplete(userId, taskCode);
        }
        this.distributedLock.unlock(key, userId.toString());
    }

    private void addComplete(Long userId, String taskCode) {
        this.taskMapper.addOne(ActivityUserTask.builder().id(this.sequenceCreater.nextLongId()).taskCode(taskCode).status(TaskStatusEnum.FINISH_UNOBTAIN.getCode()).residueTime(TaskConstant.DEFAULT_RESIDUE_TIME).display(DisplayEnum.SHOW.getCode()).userId(userId).createTime(new Date()).build());
    }

    private void updateComplete(Long userTaskId) {
        this.taskMapper.completeById(userTaskId);
    }

    @Override
    public Boolean allowReward(Long userId, String taskCode) {
        return this.newUserActivityTaskService.updateReward(userId, taskCode);
    }
}

