/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.task.impl;

import com.bxm.fossicker.activity.config.DayGoldConfig;
import com.bxm.fossicker.activity.config.TaskConfig;
import com.bxm.fossicker.activity.domain.ActivityDayGoldMapper;
import com.bxm.fossicker.activity.domain.ActivityTaskMapper;
import com.bxm.fossicker.activity.enums.DayGoldObtainStatusEnum;
import com.bxm.fossicker.activity.enums.DayGoldRedPacketStatusEnum;
import com.bxm.fossicker.activity.enums.TaskStatusEnum;
import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.dto.DayGoldDto;
import com.bxm.fossicker.activity.model.dto.DayGoldRedPacketDto;
import com.bxm.fossicker.activity.model.dto.TaskDto;
import com.bxm.fossicker.activity.model.dto.TaskListDto;
import com.bxm.fossicker.activity.model.enums.NewUserTaskEnum;
import com.bxm.fossicker.activity.model.enums.TaskTypeEnum;
import com.bxm.fossicker.activity.model.vo.ActivityDayGold;
import com.bxm.fossicker.activity.model.vo.ActivityTaskListVo;
import com.bxm.fossicker.activity.model.vo.ActivityUserTask;
import com.bxm.fossicker.activity.model.vo.NoivceRedPacketVO;
import com.bxm.fossicker.activity.model.vo.WatchVideoInfoVO;
import com.bxm.fossicker.activity.service.AccountIntegrationService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.activity.service.dispatcher.ActivityActionDispatcher;
import com.bxm.fossicker.activity.service.dispatcher.TaskActionDispatcher;
import com.bxm.fossicker.activity.service.task.TaskService;
import com.bxm.fossicker.activity.utils.AmountUtil;
import com.bxm.fossicker.base.facade.AppVersionFacadeService;
import com.bxm.fossicker.base.facade.param.AppVersionParam;
import com.bxm.fossicker.enums.TaskEnum;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.GoldFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.fossicker.vo.BasicParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LogManager.getLogger(TaskServiceImpl.class);
    private final ActivityTaskMapper taskMapper;
    private final ActivityDayGoldMapper dayGoldMapper;
    private final AccountIntegrationService accountIntegrationService;
    private final AppVersionFacadeService appVersionFacadeService;
    private final TaskConfig taskConfig;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final RedisSetAdapter redisSetAdapter;
    private final TaskActionDispatcher taskActionDispatcher;
    private final ActivityActionDispatcher actionDispatcher;
    private final DayGoldConfig dayGoldConfig;
    private final GoldFacadeService goldFacadeService;
    private final UserInfoFacadeService userInfoFacadeService;
    private final AccountFacadeService accountFacadeService;
    private final ActivityProperties activityProperties;
    private List<ActivityTaskListVo> cacheTaskList;
    private long EXPIRED_TIME = 0L;

    @Autowired
    public TaskServiceImpl(TaskActionDispatcher taskActionDispatcher, ActivityTaskMapper taskMapper, ActivityDayGoldMapper dayGoldMapper, AccountIntegrationService accountIntegrationService, AppVersionFacadeService appVersionFacadeService, TaskConfig taskConfig, RedisHashMapAdapter redisHashMapAdapter, RedisSetAdapter redisSetAdapter, ActivityProperties activityProperties, ActivityActionDispatcher actionDispatcher, UserInfoFacadeService userInfoFacadeService, AccountFacadeService accountFacadeService, DayGoldConfig dayGoldConfig, GoldFacadeService goldFacadeService) {
        this.taskActionDispatcher = taskActionDispatcher;
        this.taskMapper = taskMapper;
        this.dayGoldMapper = dayGoldMapper;
        this.accountIntegrationService = accountIntegrationService;
        this.appVersionFacadeService = appVersionFacadeService;
        this.taskConfig = taskConfig;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.activityProperties = activityProperties;
        this.actionDispatcher = actionDispatcher;
        this.userInfoFacadeService = userInfoFacadeService;
        this.accountFacadeService = accountFacadeService;
        this.dayGoldConfig = dayGoldConfig;
        this.goldFacadeService = goldFacadeService;
    }

    @Override
    public List<TaskListDto> list(Long userId, BasicParam basicParam) {
        if (null == userId) {
            return Lists.newArrayList();
        }
        KeyGenerator key = ActivityRedisKey.buildDailyTaskStatusKey((Long)userId);
        AppVersionParam param = new AppVersionParam();
        BeanUtils.copyProperties((Object)basicParam, (Object)param);
        UserInfoDto user = this.userInfoFacadeService.getUserById(userId);
        Map<String, List<TaskDto>> collect = this.localCacheTaskList().stream().map(p -> this.build((ActivityTaskListVo)p, user, key)).filter(Objects::nonNull).filter(p -> this.filter((TaskDto)p, param)).collect(Collectors.groupingBy(TaskDto::getType));
        String newUserTask = String.valueOf(TaskTypeEnum.NEW_USER_TASK.getCode());
        String dailyTask = Objects.toString(TaskTypeEnum.DAILY_TASK.getCode());
        ArrayList responseTasks = Lists.newArrayList();
        responseTasks.add(TaskListDto.builder().type(newUserTask).taskList(collect.get(newUserTask)).build());
        responseTasks.add(this.buildDailyTask(collect.get(dailyTask), dailyTask, userId));
        return responseTasks;
    }

    private List<ActivityTaskListVo> localCacheTaskList() {
        if (this.EXPIRED_TIME - System.currentTimeMillis() < 0L || this.cacheTaskList == null) {
            this.cacheTaskList = this.taskMapper.listEnableTask();
            this.EXPIRED_TIME = System.currentTimeMillis() + 300000L;
        }
        return this.cacheTaskList;
    }

    private ActivityTaskListVo getCacheTask(Long taskid) {
        Optional<ActivityTaskListVo> task = this.localCacheTaskList().stream().filter(item -> Objects.equals(taskid, item.getTaskId())).findFirst();
        return task.orElse(null);
    }

    private TaskListDto buildDailyTask(List<TaskDto> taskDtoList, String dailyTask, Long userId) {
        KeyGenerator dailyWelfareStatusKey;
        TaskListDto taskListDto = new TaskListDto();
        AtomicInteger completeNum = new AtomicInteger();
        taskDtoList.forEach(e -> {
            if (String.valueOf(TaskStatusEnum.FINISH_UNOBTAIN.getCode()).equals(e.getStatus()) || String.valueOf(TaskStatusEnum.OBTAINED.getCode()).equals(e.getStatus())) {
                completeNum.getAndIncrement();
            }
        });
        taskListDto.setTaskList(taskDtoList);
        taskListDto.setType(dailyTask);
        taskListDto.setStatus(Byte.valueOf((byte)0));
        taskListDto.setTotalNum(Integer.valueOf(taskDtoList.size()));
        taskListDto.setCompleteNum(Integer.valueOf(completeNum.get()));
        taskListDto.setDailyWelfareFlag(Byte.valueOf((byte)0));
        taskListDto.setDailyWelfareAmount(Integer.valueOf(this.activityProperties.getDefaultDailyWelfare()));
        KeyGenerator dailyWelfareVideoKey = ActivityRedisKey.DAILY_WELFARE.copy().appendKey((Object)"video");
        if (this.redisSetAdapter.exists(dailyWelfareVideoKey, (Object)userId).booleanValue()) {
            taskListDto.setDailyWelfareFlag(Byte.valueOf((byte)1));
            taskListDto.setDailyWelfareAmount(Integer.valueOf(this.activityProperties.getDailyWelfare()));
        }
        if (this.redisSetAdapter.exists(dailyWelfareStatusKey = ActivityRedisKey.DAILY_WELFARE.copy().appendKey((Object)"status"), (Object)userId).booleanValue()) {
            taskListDto.setStatus(Byte.valueOf((byte)2));
            taskListDto.setTotalNum(taskListDto.getCompleteNum());
        } else if (taskListDto.getTotalNum().equals(taskListDto.getCompleteNum())) {
            taskListDto.setStatus(Byte.valueOf((byte)1));
        }
        return taskListDto;
    }

    private boolean filter(TaskDto p, AppVersionParam param) {
        if (this.appVersionFacadeService.getAuditStatus(param).booleanValue()) {
            return this.taskConfig.getFilterIds().stream().noneMatch(p1 -> Objects.equals(p1, p.getTaskId()));
        }
        if (StringUtils.compareVersion((String)param.getCurVer(), (String)"1.3.0") < 0) {
            return this.taskConfig.getVersionOneOneTwoFilter().stream().noneMatch(p1 -> Objects.equals(p1, p.getTitle()));
        }
        return true;
    }

    private TaskDto build(ActivityTaskListVo taskListVo, UserInfoDto user, KeyGenerator key) {
        WatchVideoInfoVO watchVideoInfoVO;
        TaskDto taskDto = this.convert(taskListVo);
        if (Objects.equals(Objects.toString(TaskTypeEnum.NEW_USER_TASK.getCode()), taskListVo.getType())) {
            ActivityUserTask userTask = this.taskMapper.query(user.getId(), taskListVo.getTaskCode());
            if (Objects.equals(taskListVo.getTaskCode(), TaskEnum.INPUT_INVITE.name()) && (Objects.isNull(userTask) || Objects.equals(TaskStatusEnum.UNFINISHED.getCode(), userTask.getStatus()))) {
                if (Objects.nonNull(user.getSuperiorUserId())) {
                    return null;
                }
                if (this.userInfoFacadeService.checkIsSpecialRegChannel(user.getRegChannel()).booleanValue()) {
                    return null;
                }
                int registerDays = this.userInfoFacadeService.getRegisterDays(user.getId());
                if (registerDays > this.taskConfig.getInputInviteCodeShowDays()) {
                    return null;
                }
            }
            if (Objects.isNull(userTask)) {
                taskDto.setStatus(Objects.toString(TaskStatusEnum.UNFINISHED.getCode()));
                return taskDto;
            }
            if (Objects.equals(TaskStatusEnum.OBTAINED.getCode(), userTask.getStatus())) {
                return null;
            }
            taskDto.setStatus(Objects.toString(userTask.getStatus()));
            return taskDto;
        }
        String status = (String)this.redisHashMapAdapter.get(key, taskListVo.getTaskCode(), String.class);
        taskDto.setStatus(StringUtils.isBlank((CharSequence)status) ? TaskStatusEnum.UNFINISHED.getCode().toString() : status);
        if (Objects.equals(taskListVo.getTaskCode(), TaskEnum.WATCH_VIDEO.name()) && !Objects.isNull(watchVideoInfoVO = this.watchVideoInfo(user.getId())) && !Objects.isNull(watchVideoInfoVO.getWatchedTimes())) {
            taskDto.setDescription(taskDto.getDescription().replace("{}", watchVideoInfoVO.getWatchedTimes().toString()));
        }
        return taskDto;
    }

    private void buildDailyTaskList(Long userId, List<TaskDto> dailyTasks, KeyGenerator key, ActivityTaskListVo activityTaskListVo, TaskDto taskDto) {
        WatchVideoInfoVO watchVideoInfoVO;
        String status = (String)this.redisHashMapAdapter.get(key, activityTaskListVo.getTaskCode(), String.class);
        taskDto.setStatus(StringUtils.isBlank((CharSequence)status) ? "0" : status);
        if ("WATCH_VIDEO".equals(activityTaskListVo.getTaskCode()) && !Objects.isNull(watchVideoInfoVO = this.watchVideoInfo(userId)) && !Objects.isNull(watchVideoInfoVO.getWatchedTimes())) {
            taskDto.setDescription(taskDto.getDescription().replace("{}", watchVideoInfoVO.getWatchedTimes().toString()));
        }
        dailyTasks.add(taskDto);
    }

    private void controlContent(List<TaskDto> taskDtoList, AppVersionParam param) {
        if (this.appVersionFacadeService.getAuditStatus(param).booleanValue()) {
            taskDtoList.removeIf(taskDto -> this.taskConfig.getFilterIds().contains(taskDto.getTaskId()));
        }
        if (StringUtils.compareVersion((String)param.getCurVer(), (String)"1.3.0") < 0) {
            taskDtoList.removeIf(p -> this.taskConfig.getVersionOneOneTwoFilter().stream().anyMatch(p1 -> p1.equals(p.getTitle())));
        }
    }

    private TaskDto convert(ActivityTaskListVo activityTaskListVo) {
        TaskDto taskDto = new TaskDto();
        BeanUtils.copyProperties((Object)activityTaskListVo, (Object)taskDto);
        taskDto.setReward(AmountUtil.halfUptStringValue((BigDecimal)activityTaskListVo.getReward()));
        taskDto.setPromptImgs((List)(StringUtils.isBlank((CharSequence)activityTaskListVo.getPrompt()) ? Lists.newArrayList() : Arrays.asList(activityTaskListVo.getPrompt().split(","))));
        taskDto.setBindId(activityTaskListVo.getTaskId());
        taskDto.setType(activityTaskListVo.getType());
        return taskDto;
    }

    @Override
    public Integer obtain(Long userId, Long taskId) {
        if (null == taskId || null == userId) {
            return 0;
        }
        ActivityTaskListVo task = this.getCacheTask(taskId);
        if (null == task) {
            return 0;
        }
        boolean allowReward = this.taskActionDispatcher.getByTaskCode(task.getTaskCode()).allowReward(userId, task.getTaskCode());
        if (allowReward) {
            this.accountIntegrationService.rewardTask(userId, task.getReward(), taskId);
            return task.getReward().intValue();
        }
        return 0;
    }

    @Override
    public Boolean taskComplete(Long userId, String taskCode) {
        if (null == userId || StringUtils.isBlank((CharSequence)taskCode)) {
            return Boolean.FALSE;
        }
        this.taskActionDispatcher.getByTaskCode(taskCode).complete(userId, taskCode);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237[{}]\u5b8c\u6210\u4efb\u52a1[{}]", (Object)userId, (Object)taskCode);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean dailyTaskComplete(Long userId, Long taskId) {
        if (null == taskId) {
            return false;
        }
        ActivityTaskListVo cacheTask = this.getCacheTask(taskId);
        if (null != cacheTask && !NewUserTaskEnum.getNewUserTaskNames().contains(cacheTask.getTaskCode())) {
            return this.taskComplete(userId, cacheTask.getTaskCode());
        }
        return false;
    }

    @Override
    public Boolean indexTaskStatus(Long userId) {
        if (null == userId) {
            return Boolean.FALSE;
        }
        ActivityUserTask searchTitleTask = this.taskMapper.query(userId, NewUserTaskEnum.SEARCH_TITLE.name());
        ActivityUserTask viewVideoTask = this.taskMapper.query(userId, NewUserTaskEnum.VIEW_VIDEO.name());
        if (null == searchTitleTask || null == viewVideoTask) {
            log.error("\u7528\u6237[{}]\u67e5\u8be2\u9996\u9875\u4efb\u52a1\u72b6\u6001\u51fa\u9519\uff0c\u627e\u4e0d\u5230\u8be5\u7528\u6237\u7684\u4efb\u52a1", (Object)userId);
            return Boolean.FALSE;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u9996\u9875\u4efb\u52a1\u72b6\u6001\u67e5\u8be2\uff0c\u7528\u6237[{}]\u641c\u7d22\u6dd8\u5b9d\u6807\u9898\u4efb\u52a1\u72b6\u6001\u4e3a:[{}]\uff0c\u89c2\u770b\u7701\u94b1\u89c6\u9891\u4efb\u52a1\u72b6\u6001\u4e3a:[{}]", (Object)userId, (Object)searchTitleTask.getStatus(), (Object)viewVideoTask.getStatus());
        }
        return this.isTwoTaskComplete(searchTitleTask, viewVideoTask);
    }

    private Boolean isTwoTaskComplete(ActivityUserTask searchTitleTask, ActivityUserTask viewVideoTask) {
        return !searchTitleTask.getStatus().equals(TaskStatusEnum.UNFINISHED.ordinal()) && !viewVideoTask.getStatus().equals(TaskStatusEnum.UNFINISHED.ordinal());
    }

    @Override
    @Async
    public void hideRewardNewUserTask() {
        this.taskMapper.hideFinishedNoviceTask();
    }

    @Override
    @Async
    public void resetEverydayTask() {
        this.taskMapper.resetEverydayTask();
    }

    @Override
    public DayGoldDto dayGoldInfo(Long userId) {
        List dayGoldList = this.dayGoldMapper.listByUser(userId);
        if (CollectionUtils.isEmpty((Collection)dayGoldList)) {
            log.error("\u7528\u6237[{}]\u7684\u5929\u5929\u9886\u73b0\u91d1\u7ea2\u5305\u5217\u8868\u4e3a\u7a7a", (Object)userId);
            return null;
        }
        Date lastDate = ((ActivityDayGold)dayGoldList.get(dayGoldList.size() - 1)).getExpectDate();
        return DateUtils.before((Date)lastDate, (Date)DateUtils.getClearDate((Date)new Date())) ? null : this.convert(dayGoldList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DayGoldRedPacketDto obtainDayGold(Long userId) {
        ActivityDayGold activityDayGold = this.dayGoldMapper.query(userId, DateUtils.getClearDate((Date)new Date()));
        if (null == activityDayGold || activityDayGold.getStatus().equals(DayGoldObtainStatusEnum.HAS_OBTAIN.ordinal())) {
            return null;
        }
        this.dayGoldMapper.obtain(activityDayGold.getId());
        this.accountIntegrationService.rewardDayGold(userId, activityDayGold.getAwardAmount(), activityDayGold.getId());
        return this.convert(activityDayGold);
    }

    @Override
    public BigDecimal getRewardNum(Long taskId) {
        ActivityTaskListVo cacheTask = this.getCacheTask(taskId);
        if (null == cacheTask) {
            return BigDecimal.ZERO;
        }
        return cacheTask.getReward();
    }

    @Override
    public BigDecimal getDayGoldRewardToday(Long userId) {
        ActivityDayGold activityDayGold = this.dayGoldMapper.query(userId, DateUtils.getClearDate((Date)new Date()));
        if (null == activityDayGold || activityDayGold.getStatus().equals(DayGoldObtainStatusEnum.NOT_OBTAIN.ordinal())) {
            return null;
        }
        return activityDayGold.getAwardAmount();
    }

    @Override
    public WatchVideoInfoVO watchVideoInfo(Long userId) {
        if (userId == null) {
            return WatchVideoInfoVO.builder().build();
        }
        Integer times = (Integer)this.redisHashMapAdapter.get(ActivityRedisKey.WATCH_VIDEO.copy().appendKey((Object)((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())), userId.toString(), Integer.class);
        return WatchVideoInfoVO.builder().watchedTimes(Integer.valueOf(Objects.isNull(times) ? 0 : times)).build();
    }

    private DayGoldRedPacketDto convert(ActivityDayGold activityDayGold) {
        return DayGoldRedPacketDto.builder().day(activityDayGold.getDayNum()).status(Integer.valueOf(DayGoldObtainStatusEnum.HAS_OBTAIN.ordinal())).gold(AmountUtil.halfUptStringValue((BigDecimal)activityDayGold.getAwardAmount())).build();
    }

    private DayGoldDto convert(List<ActivityDayGold> dayGoldList) {
        DayGoldDto dayGoldDto = new DayGoldDto();
        ArrayList dayGoldRedPacketDtoList = Lists.newArrayList();
        dayGoldList.forEach(dayGold -> {
            int status = this.getStatus((ActivityDayGold)dayGold).ordinal();
            if (status == DayGoldRedPacketStatusEnum.WAIT_OBTAIN.ordinal() && !dayGoldDto.getUnObtain().booleanValue()) {
                dayGoldDto.setUnObtain(Boolean.TRUE);
            }
            dayGoldRedPacketDtoList.add(DayGoldRedPacketDto.builder().day(dayGold.getDayNum()).gold(AmountUtil.divideHalfUpScale2StringValue((BigDecimal)dayGold.getAwardAmount(), (BigDecimal)new BigDecimal(10000)) + "\u4e07").goldNum(dayGold.getAwardAmount()).status(Integer.valueOf(status)).build());
        });
        dayGoldDto.setDayGoldRedPacketDtoList((List)dayGoldRedPacketDtoList);
        return dayGoldDto;
    }

    private DayGoldRedPacketStatusEnum getStatus(ActivityDayGold dayGold) {
        if (dayGold.getStatus().equals(DayGoldObtainStatusEnum.HAS_OBTAIN.ordinal())) {
            return DayGoldRedPacketStatusEnum.HAS_OBTAIN;
        }
        if (DateUtils.before((Date)dayGold.getExpectDate(), (Date)DateUtils.getClearDate((Date)new Date()))) {
            return DayGoldRedPacketStatusEnum.OVERDUE;
        }
        if (DateUtils.getDiffSeconed((Date)dayGold.getExpectDate(), (Date)DateUtils.getClearDate((Date)new Date()), (boolean)Boolean.FALSE) == 0L) {
            return DayGoldRedPacketStatusEnum.WAIT_OBTAIN;
        }
        return DayGoldRedPacketStatusEnum.NOT_ALLOW_OBTAIN;
    }

    @Override
    public void updateDayGold() {
        List allList = this.dayGoldMapper.allList();
        if (allList.size() > 0) {
            for (ActivityDayGold activityDayGold : allList) {
                this.dayGoldMapper.updateForGoldNum(activityDayGold.getId(), new BigDecimal((Integer)this.dayGoldConfig.getAmount().get(activityDayGold.getDayNum() - 1)));
                log.info("\u6bcf\u65e5\u9886\u91d1\u5e01ID: " + activityDayGold.getId() + "\u66f4\u65b0\u91d1\u5e01\u5b8c\u6210");
            }
        }
    }

    @Override
    public NoivceRedPacketVO obtainNewUserRedPacket(Long userId) {
        if (null == userId) {
            return this.build(BigDecimal.ZERO);
        }
        BigDecimal goldNum = this.actionDispatcher.getByActivityName("new_user_red_packet").reward(userId);
        if (null == goldNum) {
            return this.build(BigDecimal.ZERO);
        }
        return this.build(goldNum);
    }

    private NoivceRedPacketVO build(BigDecimal goldNum) {
        return NoivceRedPacketVO.builder().goldNum(goldNum).goldToCash(goldNum.divide(BigDecimal.valueOf(this.goldFacadeService.getGoldToCashRate()))).build();
    }

    @Override
    public Integer receiveDailyWelfare(Long userId) {
        KeyGenerator dailyWelfareStatusKey = ActivityRedisKey.DAILY_WELFARE.copy().appendKey((Object)"status");
        if (this.redisSetAdapter.exists(dailyWelfareStatusKey, (Object)userId).booleanValue()) {
            log.error("\u7528\u6237\u5df2\u7ecf\u9886\u53d6\u8fc7\u6bcf\u65e5\u5956\u52b1\uff0c\u4e0d\u518d\u53d1\u653e\uff0c\u7528\u6237ID[{}]", (Object)userId);
            return 0;
        }
        this.redisSetAdapter.add(dailyWelfareStatusKey, new Object[]{userId});
        this.redisSetAdapter.expire(dailyWelfareStatusKey, (long)DateUtils.getCurSeconds());
        Message message = this.accountFacadeService.goldRebate(GoldRebateParam.builder().userId(userId).userGoldFlowType(UserGoldFlowTypeEnum.TASK_DAILY_WELFARE).relationId(null).amount(BigDecimal.valueOf(this.activityProperties.getDailyWelfare())).build());
        if (!message.isSuccess()) {
            log.warn("\u9886\u53d6\u6bcf\u65e5\u798f\u5229\u5956\u52b1\uff0c\u8d26\u6237\u6dfb\u52a0\u91d1\u989d\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f: {}", (Object)message.getLastMessage());
        }
        return this.activityProperties.getDailyWelfare();
    }

    @Override
    public Integer videoReport(Long userId) {
        KeyGenerator dailyWelfareVideoKey = ActivityRedisKey.DAILY_WELFARE.copy().appendKey((Object)"video");
        this.redisSetAdapter.add(dailyWelfareVideoKey, new Object[]{userId});
        this.redisSetAdapter.expire(dailyWelfareVideoKey, (long)DateUtils.getCurSeconds());
        return this.activityProperties.getDailyWelfare();
    }
}

