/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.telephonecharge.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.activity.config.TelephoneChargeConfig;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.ActivityTelephoneChargeMapper;
import com.bxm.fossicker.activity.enums.TelephoneChargeStatusEnum;
import com.bxm.fossicker.activity.facade.TelephoneChargeFacadeService;
import com.bxm.fossicker.activity.model.TelephoneChargeRuleDTO;
import com.bxm.fossicker.activity.model.entry.ActivityTelephoneCharge;
import com.bxm.fossicker.activity.model.enums.InitCostEnum;
import com.bxm.fossicker.activity.model.param.telephonecharge.InitTelephoneChargeParam;
import com.bxm.fossicker.activity.service.telephonecharge.impl.strategy.TelephoneChargeContext;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TelephoneChargeFacadeServiceImpl
implements TelephoneChargeFacadeService {
    private static final Logger log = LoggerFactory.getLogger(TelephoneChargeFacadeServiceImpl.class);
    private final TelephoneChargeConfig telephoneChargeConfig;
    private final ActivityTelephoneChargeMapper activityTelephoneChargeMapper;
    private final TelephoneChargeContext telephoneChargeContext;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final SequenceCreater sequenceCreater;
    private final DistributedLock distributedLock;

    public void addTelephoneChargeList(Long userId, Byte source) {
        Map useRuleMap = (Map)JSONObject.parseObject((String)this.telephoneChargeConfig.getUseRule(), Map.class);
        if (Objects.isNull(useRuleMap)) {
            log.error("apollo\u53d1\u653e\u89c4\u5219\u672a\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u53d1\u653e\u89c4\u5219activity.config.telephonecharge.use-rule");
            return;
        }
        TelephoneChargeRuleDTO telephoneChargeRuleDTO = new TelephoneChargeRuleDTO();
        for (int month = 1; month <= this.telephoneChargeConfig.getMonth() && !Objects.isNull(useRuleMap.get(month)); ++month) {
            telephoneChargeRuleDTO = (TelephoneChargeRuleDTO)JSONObject.parseObject((String)JSON.toJSONString(useRuleMap.get(month)), TelephoneChargeRuleDTO.class);
        }
        InitTelephoneChargeParam build = InitTelephoneChargeParam.builder().userId(userId).source(source).lastTelephoneChargeRule(telephoneChargeRuleDTO).useRuleMap(useRuleMap).build();
        ActivityTelephoneCharge lastMonthExistData = this.activityTelephoneChargeMapper.getLastMonthExistData(userId);
        if (Objects.isNull(lastMonthExistData)) {
            build.setType(InitCostEnum.FIRST_INIT.getType());
            this.telephoneChargeContext.initTelephoneCharge(build);
            return;
        }
        Date currDate = new Date();
        if (currDate.getTime() <= lastMonthExistData.getUseStartDate().getTime()) {
            build.setType(InitCostEnum.EXIST_NEXT_MONTH.getType());
            build.setLastTelephoneCharge(lastMonthExistData);
            this.telephoneChargeContext.initTelephoneCharge(build);
            return;
        }
        if (currDate.getTime() >= lastMonthExistData.getUseEndDate().getTime()) {
            build.setType(InitCostEnum.EXIST_CURR_MONTH.getType());
            this.telephoneChargeContext.initTelephoneCharge(build);
        }
    }

    public void seeVideoGainCost(Long userId) {
        Date currDate = new Date();
        ActivityTelephoneCharge activityTelephoneCharge = this.activityTelephoneChargeMapper.getCurrMonthTelephoneChargeByUserId(userId, currDate);
        if (Objects.isNull(activityTelephoneCharge)) {
            log.warn("\u770b\u89c6\u9891\u5f97\u8bdd\u8d39\u56de\u8c03\u6839\u672c\u6ca1\u8fd9\u4e2a\u7528\u6237\u7684\u8bdd\u8d39\u5217\u8868\uff0cuserId={},date={}", (Object)userId, (Object)currDate);
            return;
        }
        if (Objects.equals(activityTelephoneCharge.getStatus(), TelephoneChargeStatusEnum.USED.getStatus())) {
            log.warn("\u770b\u89c6\u9891\u5f97\u8bdd\u8d39\u56de\u8c03\uff0c\u8fd9\u4e2a\u7528\u6237\u7684\u8bdd\u8d39\u5217\u8868\u8fd9\u4e2a\u6708\u5df2\u7ecf\u4f7f\u7528\u8fc7\u4e86\uff0cactivityTelephoneCharge={}", (Object)activityTelephoneCharge);
            return;
        }
        if (activityTelephoneCharge.getFirstMonth().booleanValue()) {
            log.warn("\u7b2c\u4e00\u4e2a\u6708 \u4e0d\u9700\u8981\u770b\u89c6\u9891\uff0cactivityTelephoneCharge={}", (Object)activityTelephoneCharge);
            return;
        }
        String requestId = this.sequenceCreater.nextStringId();
        String lockKey = ActivityRedisKeyConstant.ADD_SEE_VIDEO_LOCK.copy().appendKey((Object)userId).gen();
        if (!this.distributedLock.lock(lockKey, requestId, 2L, TimeUnit.SECONDS)) {
            log.warn("\u56de\u8c03\u589e\u52a0\u7528\u6237\u770b\u89c6\u9891\u6b21\u6570\u8fc7\u4e8e\u9891\u7e41");
            return;
        }
        KeyGenerator key = this.builderRedisKey().appendKey((Object)DateUtils.formatDate((Date)currDate));
        int todaySeeVideoNum = 0;
        Integer num = (Integer)this.redisHashMapAdapter.get(key, userId.toString(), Integer.class);
        if (Objects.isNull(num)) {
            this.redisHashMapAdapter.put(key, userId.toString(), (Object)1);
            this.redisHashMapAdapter.expire(key, 86400L);
            todaySeeVideoNum = 1;
        } else {
            this.redisHashMapAdapter.put(key, userId.toString(), (Object)(num + 1));
            todaySeeVideoNum = num + 1;
        }
        if (todaySeeVideoNum == activityTelephoneCharge.getTodayNum()) {
            this.activityTelephoneChargeMapper.updateFinishDayNum(activityTelephoneCharge.getId());
        }
        this.distributedLock.unlock(lockKey, requestId);
    }

    public void addUserSeeVideoDayNum(Long userId) {
        Date currDate = new Date();
        ActivityTelephoneCharge activityTelephoneCharge = this.activityTelephoneChargeMapper.getCurrMonthTelephoneChargeByUserId(userId, currDate);
        if (Objects.isNull(activityTelephoneCharge)) {
            log.warn("addUserSeeVideoDayNum\u6839\u672c\u6ca1\u8fd9\u4e2a\u7528\u6237\u7684\u8bdd\u8d39\u5217\u8868\uff0cuserId={},date={}", (Object)userId, (Object)currDate);
            return;
        }
        if (Objects.equals(activityTelephoneCharge.getStatus(), TelephoneChargeStatusEnum.USED.getStatus())) {
            log.warn("\u770b\u89c6\u9891\u5f97\u8bdd\u8d39\u56de\u8c03\uff0c\u8fd9\u4e2a\u7528\u6237\u7684\u8bdd\u8d39\u5217\u8868\u8fd9\u4e2a\u6708\u5df2\u7ecf\u4f7f\u7528\u8fc7\u4e86\uff0cactivityTelephoneCharge={}", (Object)activityTelephoneCharge);
            return;
        }
        if (Objects.equals(activityTelephoneCharge.getFinishDayNum(), activityTelephoneCharge.getNeedDayNum())) {
            return;
        }
        this.activityTelephoneChargeMapper.updateFinishDayNum(activityTelephoneCharge.getId());
    }

    private KeyGenerator builderRedisKey() {
        return ActivityRedisKeyConstant.COST_SEE_VIDEO_NUM.copy();
    }

    public TelephoneChargeFacadeServiceImpl(TelephoneChargeConfig telephoneChargeConfig, ActivityTelephoneChargeMapper activityTelephoneChargeMapper, TelephoneChargeContext telephoneChargeContext, RedisHashMapAdapter redisHashMapAdapter, SequenceCreater sequenceCreater, DistributedLock distributedLock) {
        this.telephoneChargeConfig = telephoneChargeConfig;
        this.activityTelephoneChargeMapper = activityTelephoneChargeMapper;
        this.telephoneChargeContext = telephoneChargeContext;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.sequenceCreater = sequenceCreater;
        this.distributedLock = distributedLock;
    }
}

