/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.telephonecharge.impl;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.ActivityTelephoneChargeMapper;
import com.bxm.fossicker.activity.enums.TelephoneChargeStatusEnum;
import com.bxm.fossicker.activity.model.dto.telephonecharge.TelephoneChargeListDTO;
import com.bxm.fossicker.activity.model.dto.telephonecharge.UseTelephoneChargeDTO;
import com.bxm.fossicker.activity.model.dto.telephonecharge.UserTelephoneChargeDTO;
import com.bxm.fossicker.activity.model.entry.ActivityTelephoneCharge;
import com.bxm.fossicker.activity.model.param.telephonecharge.TelephoneChargeListParam;
import com.bxm.fossicker.activity.service.telephonecharge.TelephoneChargeService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.TelephoneChargeAddParam;
import com.bxm.fossicker.user.model.dto.AccountDetailDto;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TelephoneChargeServiceImpl
implements TelephoneChargeService {
    private static final Logger log = LoggerFactory.getLogger(TelephoneChargeServiceImpl.class);
    private final ActivityTelephoneChargeMapper activityTelephoneChargeMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final AccountFacadeService accountFacadeService;

    @Override
    public PageWarper<TelephoneChargeListDTO> getList(TelephoneChargeListParam telephoneChargeListParam) {
        if (Objects.isNull(telephoneChargeListParam.getStatus())) {
            telephoneChargeListParam.setStatus(Integer.valueOf(0));
        }
        Page activityTelephoneChargePageWarper = PageMethod.startPage((Object)telephoneChargeListParam).doSelectPage(() -> this.activityTelephoneChargeMapper.getActivityTelephoneChargeList(telephoneChargeListParam));
        List activityTelephoneChargeList = activityTelephoneChargePageWarper.getResult();
        ArrayList<TelephoneChargeListDTO> chargeListDTOS = new ArrayList<TelephoneChargeListDTO>();
        KeyGenerator key = ActivityRedisKeyConstant.USER_EXIST_COST_LIST.copy();
        String isExistSeeCostDate = (String)this.redisHashMapAdapter.get(key, telephoneChargeListParam.getUserId().toString(), String.class);
        Date firstInitDate = null;
        Date secondDate = null;
        if (StringUtils.isNotBlank((CharSequence)isExistSeeCostDate)) {
            firstInitDate = DateUtils.parseDate((String)isExistSeeCostDate);
            secondDate = org.apache.commons.lang3.time.DateUtils.addMonths((Date)firstInitDate, (int)1);
        }
        boolean firstMonthTelephoneCharge = false;
        for (int i = 0; i < activityTelephoneChargeList.size(); ++i) {
            TelephoneChargeListDTO telephoneChargeListDTO = new TelephoneChargeListDTO();
            ActivityTelephoneCharge activityTelephoneCharge = (ActivityTelephoneCharge)activityTelephoneChargeList.get(i);
            if (telephoneChargeListParam.getPageNum() == 1) {
                if (!activityTelephoneCharge.getFirstMonth().booleanValue() && i == 0) {
                    boolean isSecondMonth;
                    boolean bl = isSecondMonth = Objects.nonNull(secondDate) && secondDate.getTime() >= activityTelephoneCharge.getUseStartDate().getTime() && secondDate.getTime() <= activityTelephoneCharge.getUseEndDate().getTime();
                    if (!isSecondMonth) {
                        telephoneChargeListDTO.setTodayNum(activityTelephoneCharge.getTodayNum());
                        telephoneChargeListDTO.setFinishDayNum(activityTelephoneCharge.getFinishDayNum());
                        telephoneChargeListDTO.setNeedDayNum(activityTelephoneCharge.getNeedDayNum());
                    }
                    telephoneChargeListDTO.setUseStartDate(activityTelephoneCharge.getUseStartDate());
                    telephoneChargeListDTO.setUseEndDate(activityTelephoneCharge.getUseEndDate());
                }
                if (firstMonthTelephoneCharge) {
                    telephoneChargeListDTO.setUseStartDate(activityTelephoneCharge.getUseStartDate());
                    telephoneChargeListDTO.setUseEndDate(activityTelephoneCharge.getUseEndDate());
                    firstMonthTelephoneCharge = false;
                }
                if (activityTelephoneCharge.getFirstMonth().booleanValue()) {
                    firstMonthTelephoneCharge = true;
                }
            }
            telephoneChargeListDTO.setId(activityTelephoneCharge.getId().toString());
            telephoneChargeListDTO.setUserId(activityTelephoneCharge.getUserId());
            telephoneChargeListDTO.setStatus(activityTelephoneCharge.getStatus());
            telephoneChargeListDTO.setAmount(activityTelephoneCharge.getAmount());
            telephoneChargeListDTO.setUsedDate(activityTelephoneCharge.getUsedTime());
            telephoneChargeListDTO.setExpireDate(activityTelephoneCharge.getExpiredTime());
            chargeListDTOS.add(telephoneChargeListDTO);
        }
        PageWarper pageWarper = new PageWarper((List)activityTelephoneChargePageWarper);
        pageWarper.setList(chargeListDTOS);
        return pageWarper;
    }

    @Override
    public UseTelephoneChargeDTO useTelephoneCharge(Long userId, Long id) {
        ActivityTelephoneCharge activityTelephoneCharge = this.activityTelephoneChargeMapper.selectByPrimaryKey(id);
        if (Objects.isNull(activityTelephoneCharge)) {
            return UseTelephoneChargeDTO.builder().status(Integer.valueOf(-1)).msg("\u4fe1\u606f\u4e0d\u5b58\u5728").build();
        }
        if (Objects.equals(activityTelephoneCharge.getStatus(), TelephoneChargeStatusEnum.USED.getStatus())) {
            return UseTelephoneChargeDTO.builder().status(Integer.valueOf(-1)).msg("\u8be5\u6708\u8bdd\u8d39\u5df2\u88ab\u9886\u53d6").build();
        }
        if (activityTelephoneCharge.getFirstMonth().booleanValue()) {
            if (!this.addWithdrawalTelephoneCharge(activityTelephoneCharge.getAmount(), activityTelephoneCharge.getUserId(), id).booleanValue()) {
                return UseTelephoneChargeDTO.builder().status(Integer.valueOf(-1)).msg("\u64cd\u4f5c\u8d26\u6237\u5931\u8d25").build();
            }
            this.updateTelephoneChargeStatus(activityTelephoneCharge.getId(), TelephoneChargeStatusEnum.USED.getStatus());
            return UseTelephoneChargeDTO.builder().status(Integer.valueOf(3)).msg("10\u5143").build();
        }
        if (Objects.equals(activityTelephoneCharge.getStatus(), TelephoneChargeStatusEnum.SHOW.getStatus())) {
            return UseTelephoneChargeDTO.builder().status(Integer.valueOf(2)).msg("\u672c\u6b21\u8bdd\u8d39\u4e0b\u6708\u53ef\u4f7f\u7528").build();
        }
        if (activityTelephoneCharge.getFinishDayNum() >= activityTelephoneCharge.getNeedDayNum()) {
            if (!this.addWithdrawalTelephoneCharge(activityTelephoneCharge.getAmount(), activityTelephoneCharge.getUserId(), id).booleanValue()) {
                return UseTelephoneChargeDTO.builder().status(Integer.valueOf(-1)).msg("\u64cd\u4f5c\u8d26\u6237\u5931\u8d25").build();
            }
            this.updateTelephoneChargeStatus(activityTelephoneCharge.getId(), TelephoneChargeStatusEnum.USED.getStatus());
            return UseTelephoneChargeDTO.builder().status(Integer.valueOf(3)).msg("10\u5143").build();
        }
        KeyGenerator key = ActivityRedisKeyConstant.COST_SEE_VIDEO_NUM.copy().appendKey((Object)DateUtils.formatDate((Date)new Date()));
        Integer num = (Integer)this.redisHashMapAdapter.get(key, userId.toString(), Integer.class);
        if (Objects.isNull(num)) {
            return UseTelephoneChargeDTO.builder().status(Integer.valueOf(0)).msg("\u6bcf\u65e5\u770b\u89c6\u9891\u4f7f\u7528\u8bdd\u8d39").build();
        }
        if (num >= activityTelephoneCharge.getTodayNum()) {
            return UseTelephoneChargeDTO.builder().status(Integer.valueOf(1)).msg("\u4eca\u65e5\u770b\u89c6\u9891\u5df2\u5b8c\u6210").build();
        }
        return UseTelephoneChargeDTO.builder().status(Integer.valueOf(0)).msg("\u6bcf\u65e5\u770b\u89c6\u9891\u4f7f\u7528\u8bdd\u8d39").build();
    }

    @Override
    public UserTelephoneChargeDTO getUserTelephoneChargeInfo(Long userId) {
        AccountDetailDto userAccountInfoCash = this.accountFacadeService.getUserAccountInfoCash(userId);
        UserTelephoneChargeDTO userTelephoneChargeDTO = new UserTelephoneChargeDTO();
        userTelephoneChargeDTO.setNotUseMoney(Objects.isNull(userAccountInfoCash) ? new BigDecimal(0) : userAccountInfoCash.getValidChargeCash());
        return userTelephoneChargeDTO;
    }

    private void updateTelephoneChargeStatus(Long id, Byte status) {
        ActivityTelephoneCharge record = new ActivityTelephoneCharge();
        record.setId(id);
        record.setStatus(status);
        record.setUsedTime(new Date());
        this.activityTelephoneChargeMapper.updateByPrimaryKeySelective(record);
    }

    private Boolean addWithdrawalTelephoneCharge(BigDecimal amount, Long userId, Long relationId) {
        try {
            this.accountFacadeService.addWithdrawalTelephoneCharge(TelephoneChargeAddParam.builder().amount(amount).userId(userId).cashFlowType(UserCashFlowTypeEnum.CHARGE_INCREMENT).relationId(relationId).build());
        }
        catch (Exception e) {
            log.error("");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void updateUserAccountTelephoneCharge() {
        Date date = org.apache.commons.lang3.time.DateUtils.addMonths((Date)new Date(), (int)-1);
        List expireCostUserList = this.activityTelephoneChargeMapper.getExpireCostUserList(date);
        try {
            expireCostUserList.forEach(activityTelephoneCharge -> this.accountFacadeService.addExpireTelephoneCharge(TelephoneChargeAddParam.builder().amount(activityTelephoneCharge.getAmount()).userId(activityTelephoneCharge.getUserId()).cashFlowType(UserCashFlowTypeEnum.CHARGE_INCREMENT).relationId(activityTelephoneCharge.getId()).build()));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e0a\u4e2a\u6708\u8fd8\u662f\u4f7f\u7528\u72b6\u6001\u7684\u8bdd\u8d39\uff0c\u66f4\u65b0\u4e3a\u5931\u6548\u8bdd\u8d39\u51fa\u9519", (Throwable)e);
        }
    }

    public TelephoneChargeServiceImpl(ActivityTelephoneChargeMapper activityTelephoneChargeMapper, RedisHashMapAdapter redisHashMapAdapter, AccountFacadeService accountFacadeService) {
        this.activityTelephoneChargeMapper = activityTelephoneChargeMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.accountFacadeService = accountFacadeService;
    }
}

