/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.telephonecharge.impl.strategy;

import com.bxm.fossicker.activity.config.TelephoneChargeConfig;
import com.bxm.fossicker.activity.domain.ActivityTelephoneChargeMapper;
import com.bxm.fossicker.activity.enums.TelephoneChargeStatusEnum;
import com.bxm.fossicker.activity.model.TelephoneChargeRuleDTO;
import com.bxm.fossicker.activity.model.entry.ActivityTelephoneCharge;
import com.bxm.fossicker.activity.model.enums.InitCostEnum;
import com.bxm.fossicker.activity.model.param.telephonecharge.InitTelephoneChargeParam;
import com.bxm.fossicker.activity.service.telephonecharge.impl.strategy.InitTelephoneChargeStrategy;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.TelephoneChargeAddParam;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExistTelephoneChargeCurrInitStrategy
extends InitTelephoneChargeStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExistTelephoneChargeCurrInitStrategy.class);
    private final TelephoneChargeConfig telephoneChargeConfig;
    private final SequenceCreater sequenceCreater;
    private final ActivityTelephoneChargeMapper activityTelephoneChargeMapper;
    private final AccountFacadeService accountFacadeService;

    @Override
    public void initTelephoneCharge(InitTelephoneChargeParam initTelephoneChargeParam) {
        Long relationId = this.sequenceCreater.nextLongId();
        List<ActivityTelephoneCharge> telephoneCharges = this.initTelephoneChargesList(initTelephoneChargeParam, relationId);
        this.activityTelephoneChargeMapper.batchInsertData(telephoneCharges);
        this.accountFacadeService.addUseTelephoneCharge(TelephoneChargeAddParam.builder().amount(this.telephoneChargeConfig.getMoney().multiply(BigDecimal.valueOf(this.telephoneChargeConfig.getMonth().intValue()))).userId(initTelephoneChargeParam.getUserId()).cashFlowType(UserCashFlowTypeEnum.CHARGE_INCREMENT).relationId(relationId).build());
    }

    @Override
    public Integer getType() {
        return InitCostEnum.EXIST_CURR_MONTH.getType();
    }

    private List<ActivityTelephoneCharge> initTelephoneChargesList(InitTelephoneChargeParam initTelephoneChargeParam, Long relationId) {
        Date currDate = null;
        ArrayList<ActivityTelephoneCharge> telephoneCharges = new ArrayList<ActivityTelephoneCharge>();
        TelephoneChargeRuleDTO ruleDTO = initTelephoneChargeParam.getLastTelephoneChargeRule();
        for (int month = 1; month <= this.telephoneChargeConfig.getMonth(); ++month) {
            currDate = Objects.isNull(currDate) ? new Date() : DateUtils.addMonths(currDate, (int)1);
            Date[] lastDayAndFirstDay = ExistTelephoneChargeCurrInitStrategy.getLastDayAndFirstDay(currDate);
            ActivityTelephoneCharge activityTelephoneCharge = new ActivityTelephoneCharge();
            activityTelephoneCharge.setCreateTime(new Date());
            activityTelephoneCharge.setSource(initTelephoneChargeParam.getSource());
            activityTelephoneCharge.setId(relationId == null ? this.sequenceCreater.nextLongId() : relationId);
            activityTelephoneCharge.setUserId(initTelephoneChargeParam.getUserId());
            activityTelephoneCharge.setAmount(this.telephoneChargeConfig.getMoney());
            activityTelephoneCharge.setFirstMonth(Boolean.FALSE);
            Date[] currMonthDate = initTelephoneChargeParam.getCurrMonthDate();
            Date[] nextMonthDate = initTelephoneChargeParam.getNextMonthDate();
            activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.LOCK.getStatus());
            if (currDate.getTime() >= currMonthDate[0].getTime() && currDate.getTime() <= currMonthDate[1].getTime()) {
                activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.USE.getStatus());
            }
            if (currDate.getTime() >= nextMonthDate[0].getTime() && currDate.getTime() <= nextMonthDate[1].getTime()) {
                activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.SHOW.getStatus());
            }
            activityTelephoneCharge.setTodayNum(ruleDTO.getNeedTodayVideoNum());
            activityTelephoneCharge.setNeedDayNum(ruleDTO.getNeedDayNum());
            activityTelephoneCharge.setFinishDayNum(Integer.valueOf(0));
            activityTelephoneCharge.setUseStartDate(lastDayAndFirstDay[0]);
            activityTelephoneCharge.setUseEndDate(lastDayAndFirstDay[1]);
            telephoneCharges.add(activityTelephoneCharge);
            currDate = lastDayAndFirstDay[0];
            relationId = null;
        }
        return telephoneCharges;
    }

    public ExistTelephoneChargeCurrInitStrategy(TelephoneChargeConfig telephoneChargeConfig, SequenceCreater sequenceCreater, ActivityTelephoneChargeMapper activityTelephoneChargeMapper, AccountFacadeService accountFacadeService) {
        this.telephoneChargeConfig = telephoneChargeConfig;
        this.sequenceCreater = sequenceCreater;
        this.activityTelephoneChargeMapper = activityTelephoneChargeMapper;
        this.accountFacadeService = accountFacadeService;
    }
}

