/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.telephonecharge.impl.strategy;

import com.bxm.fossicker.activity.config.TelephoneChargeConfig;
import com.bxm.fossicker.activity.domain.ActivityTelephoneChargeMapper;
import com.bxm.fossicker.activity.enums.TelephoneChargeStatusEnum;
import com.bxm.fossicker.activity.model.TelephoneChargeRuleDTO;
import com.bxm.fossicker.activity.model.entry.ActivityTelephoneCharge;
import com.bxm.fossicker.activity.model.enums.InitCostEnum;
import com.bxm.fossicker.activity.model.param.telephonecharge.InitTelephoneChargeParam;
import com.bxm.fossicker.activity.service.telephonecharge.impl.strategy.InitTelephoneChargeStrategy;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.TelephoneChargeAddParam;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExistTelephoneChargeNextInitStrategy
extends InitTelephoneChargeStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExistTelephoneChargeNextInitStrategy.class);
    private final TelephoneChargeConfig telephoneChargeConfig;
    private final SequenceCreater sequenceCreater;
    private final ActivityTelephoneChargeMapper activityTelephoneChargeMapper;
    private final AccountFacadeService accountFacadeService;

    @Override
    public void initTelephoneCharge(InitTelephoneChargeParam initTelephoneChargeParam) {
        Long relationId = this.sequenceCreater.nextLongId();
        List<ActivityTelephoneCharge> telephoneCharges = this.initTelephoneChargesList(initTelephoneChargeParam, relationId);
        this.activityTelephoneChargeMapper.batchInsertData(telephoneCharges);
        this.accountFacadeService.addUseTelephoneCharge(TelephoneChargeAddParam.builder().amount(this.telephoneChargeConfig.getMoney().multiply(BigDecimal.valueOf(this.telephoneChargeConfig.getMonth().intValue()))).userId(initTelephoneChargeParam.getUserId()).cashFlowType(UserCashFlowTypeEnum.CHARGE_INCREMENT).relationId(relationId).build());
    }

    @Override
    public Integer getType() {
        return InitCostEnum.EXIST_NEXT_MONTH.getType();
    }

    private List<ActivityTelephoneCharge> initTelephoneChargesList(InitTelephoneChargeParam initTelephoneChargeParam, Long relationId) {
        ActivityTelephoneCharge lastTelephoneCharge = initTelephoneChargeParam.getLastTelephoneCharge();
        TelephoneChargeRuleDTO ruleDTO = initTelephoneChargeParam.getLastTelephoneChargeRule();
        Date currDate = null;
        ArrayList<ActivityTelephoneCharge> telephoneCharges = new ArrayList<ActivityTelephoneCharge>();
        for (int month = 1; month <= this.telephoneChargeConfig.getMonth(); ++month) {
            currDate = Objects.isNull(currDate) ? DateUtils.addMonths((Date)lastTelephoneCharge.getUseStartDate(), (int)1) : DateUtils.addMonths(currDate, (int)1);
            Date[] lastDayAndFirstDay = ExistTelephoneChargeNextInitStrategy.getLastDayAndFirstDay(currDate);
            ActivityTelephoneCharge activityTelephoneCharge = new ActivityTelephoneCharge();
            activityTelephoneCharge.setFirstMonth(Boolean.FALSE);
            activityTelephoneCharge.setSource(initTelephoneChargeParam.getSource());
            activityTelephoneCharge.setId(relationId == null ? this.sequenceCreater.nextLongId() : relationId);
            activityTelephoneCharge.setUserId(initTelephoneChargeParam.getUserId());
            activityTelephoneCharge.setAmount(this.telephoneChargeConfig.getMoney());
            activityTelephoneCharge.setCreateTime(new Date());
            activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.LOCK.getStatus());
            activityTelephoneCharge.setNeedDayNum(ruleDTO.getNeedDayNum());
            activityTelephoneCharge.setTodayNum(ruleDTO.getNeedTodayVideoNum());
            activityTelephoneCharge.setFinishDayNum(Integer.valueOf(0));
            activityTelephoneCharge.setUseStartDate(lastDayAndFirstDay[0]);
            activityTelephoneCharge.setUseEndDate(lastDayAndFirstDay[1]);
            telephoneCharges.add(activityTelephoneCharge);
            currDate = lastDayAndFirstDay[0];
            relationId = null;
        }
        return telephoneCharges;
    }

    public ExistTelephoneChargeNextInitStrategy(TelephoneChargeConfig telephoneChargeConfig, SequenceCreater sequenceCreater, ActivityTelephoneChargeMapper activityTelephoneChargeMapper, AccountFacadeService accountFacadeService) {
        this.telephoneChargeConfig = telephoneChargeConfig;
        this.sequenceCreater = sequenceCreater;
        this.activityTelephoneChargeMapper = activityTelephoneChargeMapper;
        this.accountFacadeService = accountFacadeService;
    }
}

