/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.telephonecharge.impl.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.activity.config.TelephoneChargeConfig;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.ActivityTelephoneChargeMapper;
import com.bxm.fossicker.activity.enums.TelephoneChargeStatusEnum;
import com.bxm.fossicker.activity.model.TelephoneChargeRuleDTO;
import com.bxm.fossicker.activity.model.entry.ActivityTelephoneCharge;
import com.bxm.fossicker.activity.model.enums.InitCostEnum;
import com.bxm.fossicker.activity.model.param.telephonecharge.InitTelephoneChargeParam;
import com.bxm.fossicker.activity.service.telephonecharge.impl.strategy.InitTelephoneChargeStrategy;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.TelephoneChargeAddParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FirstInitTelephoneChargeStrategy
extends InitTelephoneChargeStrategy {
    private static final Logger log = LoggerFactory.getLogger(FirstInitTelephoneChargeStrategy.class);
    private final TelephoneChargeConfig telephoneChargeConfig;
    private final SequenceCreater sequenceCreater;
    private final ActivityTelephoneChargeMapper activityTelephoneChargeMapper;
    private final AccountFacadeService accountFacadeService;
    private final RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public void initTelephoneCharge(InitTelephoneChargeParam initTelephoneChargeParam) {
        Long relationId = this.sequenceCreater.nextLongId();
        List<ActivityTelephoneCharge> telephoneCharges = this.initTelephoneChargesList(initTelephoneChargeParam, relationId);
        this.activityTelephoneChargeMapper.batchInsertData(telephoneCharges);
        this.accountFacadeService.addUseTelephoneCharge(TelephoneChargeAddParam.builder().amount(this.telephoneChargeConfig.getMoney().multiply(BigDecimal.valueOf(this.telephoneChargeConfig.getMonth().intValue()))).userId(initTelephoneChargeParam.getUserId()).cashFlowType(UserCashFlowTypeEnum.CHARGE_INCREMENT).relationId(relationId).build());
        KeyGenerator key = ActivityRedisKeyConstant.USER_EXIST_COST_LIST.copy();
        this.redisHashMapAdapter.put(key, initTelephoneChargeParam.getUserId().toString(), (Object)DateUtils.formatDate((Date)new Date()));
    }

    @Override
    public Integer getType() {
        return InitCostEnum.FIRST_INIT.getType();
    }

    private List<ActivityTelephoneCharge> initTelephoneChargesList(InitTelephoneChargeParam initTelephoneChargeParam, Long relationId) {
        Map useRuleMap = initTelephoneChargeParam.getUseRuleMap();
        Date currDate = null;
        ArrayList<ActivityTelephoneCharge> telephoneCharges = new ArrayList<ActivityTelephoneCharge>();
        for (int month = 1; month <= this.telephoneChargeConfig.getMonth(); ++month) {
            currDate = Objects.isNull(currDate) ? new Date() : org.apache.commons.lang3.time.DateUtils.addMonths(currDate, (int)1);
            Date[] lastDayAndFirstDay = FirstInitTelephoneChargeStrategy.getLastDayAndFirstDay(currDate);
            TelephoneChargeRuleDTO ruleDTO = (TelephoneChargeRuleDTO)JSONObject.parseObject((String)JSON.toJSONString(useRuleMap.get(month)), TelephoneChargeRuleDTO.class);
            ruleDTO = Objects.nonNull(ruleDTO) ? ruleDTO : initTelephoneChargeParam.getLastTelephoneChargeRule();
            ActivityTelephoneCharge activityTelephoneCharge = new ActivityTelephoneCharge();
            activityTelephoneCharge.setSource(initTelephoneChargeParam.getSource());
            activityTelephoneCharge.setId(relationId == null ? this.sequenceCreater.nextLongId() : relationId);
            activityTelephoneCharge.setUserId(initTelephoneChargeParam.getUserId());
            activityTelephoneCharge.setAmount(this.telephoneChargeConfig.getMoney());
            activityTelephoneCharge.setCreateTime(new Date());
            activityTelephoneCharge.setFirstMonth(Boolean.FALSE);
            activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.LOCK.getStatus());
            Date[] currMonthDate = initTelephoneChargeParam.getCurrMonthDate();
            Date[] nextMonthDate = initTelephoneChargeParam.getNextMonthDate();
            activityTelephoneCharge.setFinishDayNum(Integer.valueOf(0));
            if (currDate.getTime() >= currMonthDate[0].getTime() && currDate.getTime() <= currMonthDate[1].getTime()) {
                activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.USE.getStatus());
                activityTelephoneCharge.setFinishDayNum(Integer.valueOf(1));
                activityTelephoneCharge.setFirstMonth(Boolean.TRUE);
            }
            if (currDate.getTime() >= nextMonthDate[0].getTime() && currDate.getTime() <= nextMonthDate[1].getTime()) {
                activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.SHOW.getStatus());
            }
            activityTelephoneCharge.setTodayNum(ruleDTO.getNeedTodayVideoNum());
            activityTelephoneCharge.setNeedDayNum(ruleDTO.getNeedDayNum());
            activityTelephoneCharge.setUseStartDate(lastDayAndFirstDay[0]);
            activityTelephoneCharge.setUseEndDate(lastDayAndFirstDay[1]);
            telephoneCharges.add(activityTelephoneCharge);
            currDate = lastDayAndFirstDay[0];
            relationId = null;
        }
        return telephoneCharges;
    }

    public FirstInitTelephoneChargeStrategy(TelephoneChargeConfig telephoneChargeConfig, SequenceCreater sequenceCreater, ActivityTelephoneChargeMapper activityTelephoneChargeMapper, AccountFacadeService accountFacadeService, RedisHashMapAdapter redisHashMapAdapter) {
        this.telephoneChargeConfig = telephoneChargeConfig;
        this.sequenceCreater = sequenceCreater;
        this.activityTelephoneChargeMapper = activityTelephoneChargeMapper;
        this.accountFacadeService = accountFacadeService;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }
}

