/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.telephonecharge.impl.strategy;

import com.bxm.fossicker.activity.model.param.telephonecharge.InitTelephoneChargeParam;
import com.bxm.fossicker.activity.service.telephonecharge.impl.strategy.InitTelephoneChargeStrategy;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TelephoneChargeContext {
    private static final Logger log = LoggerFactory.getLogger(TelephoneChargeContext.class);
    private HashMap<Integer, InitTelephoneChargeStrategy> strategyMap;

    public TelephoneChargeContext(List<InitTelephoneChargeStrategy> strategies) {
        this.strategyMap = new HashMap((int)((float)strategies.size() / 0.75f) + 1);
        strategies.forEach(entity -> this.strategyMap.put(entity.getType(), (InitTelephoneChargeStrategy)entity));
    }

    public void initTelephoneCharge(InitTelephoneChargeParam initTelephoneChargeParam) {
        InitTelephoneChargeStrategy initTelephoneChargeStrategy = this.strategyMap.get(initTelephoneChargeParam.getType());
        initTelephoneChargeParam.setCurrMonthDate(InitTelephoneChargeStrategy.getLastDayAndFirstDay(new Date()));
        initTelephoneChargeParam.setNextMonthDate(InitTelephoneChargeStrategy.getLastDayAndFirstDay(DateUtils.addMonths((Date)new Date(), (int)1)));
        log.info("\u751f\u6210\u8bdd\u8d39\u8bf7\u6c42\u53c2\u6570initTelephoneChargeParam\uff1a{}", (Object)initTelephoneChargeParam);
        initTelephoneChargeStrategy.initTelephoneCharge(initTelephoneChargeParam);
    }
}

