/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.unicom.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.domain.ActivityUnicomInfoMapper;
import com.bxm.fossicker.activity.domain.ActivityUnicomPhoneInfoMapper;
import com.bxm.fossicker.activity.model.param.UnicomMatchPhoneParam;
import com.bxm.fossicker.activity.model.param.UnicomParam;
import com.bxm.fossicker.activity.model.vo.UnicomInfo;
import com.bxm.fossicker.activity.model.vo.UnicomPhoneInfo;
import com.bxm.fossicker.activity.service.unicom.UnicomService;
import com.bxm.fossicker.activity.service.unicom.util.ValidatorlUtils;
import com.bxm.fossicker.message.enums.SmsTempEnum;
import com.bxm.fossicker.message.facade.SmsFacadeService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UnicomServiceImpl
implements UnicomService {
    private static final Logger log = LogManager.getLogger(UnicomServiceImpl.class);
    @Resource
    ActivityUnicomInfoMapper activityUnicomInfoMapper;
    @Resource
    ActivityUnicomPhoneInfoMapper activityUnicomPhoneInfoMapper;
    @Autowired
    SmsFacadeService smsFacadeService;
    private static String PROVINCE = "330000";

    @Override
    public Message saveUnicomUserInfo(UnicomParam unicomParam) {
        log.info("unicomParam {}", (Object)JSON.toJSONString((Object)unicomParam));
        String checkStr = this.checkParam(unicomParam);
        if (Objects.nonNull(checkStr)) {
            return Message.build().setSuccess(false).setMessage(checkStr);
        }
        this.saveUnicom(unicomParam);
        return Message.build().setSuccess(true);
    }

    @Override
    public PageWarper<String> getPhoneList(UnicomMatchPhoneParam unicomMatchPhoneParam) {
        log.info("unicomMatchPhoneParam {}", (Object)JSON.toJSONString((Object)unicomMatchPhoneParam));
        List phoneList = this.activityUnicomPhoneInfoMapper.getPhoneList(unicomMatchPhoneParam);
        return new PageWarper(phoneList);
    }

    @Override
    public Message sendMsg(String phoneNumb, HttpServletRequest request) {
        log.info("phoneNumb {}" + phoneNumb);
        if (Objects.isNull(phoneNumb) || !Validater.checkPhone((String)phoneNumb)) {
            return Message.build().setSuccess(false).setMessage("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        String ip = WebUtils.getIpAddr((HttpServletRequest)request);
        return this.smsFacadeService.sendSmsCode(phoneNumb, SmsTempEnum.UNCICOME, ip);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveUnicom(UnicomParam unicomParam) {
        UnicomInfo unicomInfo = new UnicomInfo();
        BeanUtils.copyProperties((Object)unicomParam, (Object)unicomInfo);
        this.activityUnicomInfoMapper.saveUnicomInfo(unicomInfo);
        if (Objects.nonNull(unicomParam.getSelectedPhoneNumb())) {
            UnicomPhoneInfo unicomPhoneInfo = UnicomPhoneInfo.builder().idCard(unicomParam.getIdCard()).usable(Integer.valueOf(1)).phoneNumb(unicomParam.getSelectedPhoneNumb().trim()).unicomId(unicomInfo.getId()).build();
            this.activityUnicomPhoneInfoMapper.updateUnicomPhoneInfo(unicomPhoneInfo);
        }
    }

    private String checkParam(UnicomParam unicomParam) {
        if (!ValidatorlUtils.checkIdentityCode(unicomParam.getIdCard())) {
            return "\u8eab\u4efd\u8bc1\u683c\u5f0f\u9519\u8bef";
        }
        if (!Validater.checkPhone((String)unicomParam.getPhone())) {
            return "\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef";
        }
        if (!unicomParam.getOwnerProvince().contains(PROVINCE) && StringUtils.isNotBlank((CharSequence)unicomParam.getSelectedPhoneNumb())) {
            return "\u975e\u6d59\u6c5f\u7701\u4e0d\u80fd\u9009\u62e9\u5361\u53f7\uff01";
        }
        String code = this.smsFacadeService.getCode(unicomParam.getPhone(), SmsTempEnum.UNCICOME);
        if (!StringUtils.equals((CharSequence)unicomParam.getSmsCode(), (CharSequence)code)) {
            return "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef";
        }
        this.smsFacadeService.rmCode(unicomParam.getPhone(), SmsTempEnum.UNCICOME);
        return null;
    }
}

