/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.welfare.impl;

import com.bxm.fossicker.activity.config.NewbieWelfareConfig;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.service.welfare.NewUserWelfareService;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NewUserWelfareServiceImpl
implements NewUserWelfareService {
    private static final Logger log = LoggerFactory.getLogger(NewUserWelfareServiceImpl.class);
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final AccountFacadeService accountFacadeService;
    private final NewbieWelfareConfig newbieWelfareConfig;
    private final DistributedLock distributedLock;
    private final SequenceCreater sequenceCreate;

    @Override
    public Boolean isSendGold(Long userId) {
        return this.redisHashMapAdapter.exists(this.buildUserSendGoldKey(), userId.toString());
    }

    @Override
    public Message sendGold(Long userId) {
        Boolean userSendGold = this.redisHashMapAdapter.exists(this.buildUserSendGoldKey(), userId.toString());
        if (userSendGold.booleanValue()) {
            return Message.build((boolean)false).setMessage("\u7528\u6237\u5df2\u83b7\u53d6\u8fc7\u6b64\u798f\u5229");
        }
        String requestId = this.sequenceCreate.nextStringId();
        this.distributedLock.lock(userId.toString(), requestId, 3L, TimeUnit.SECONDS);
        Message message = this.accountFacadeService.goldRebate(GoldRebateParam.builder().userId(userId).userGoldFlowType(UserGoldFlowTypeEnum.NEWBIE_REGISTER_WELFARE).relationId(null).amount(BigDecimal.valueOf(this.newbieWelfareConfig.getNewbieWelfare().intValue())).build());
        if (message.isSuccess()) {
            this.redisHashMapAdapter.put(this.buildUserSendGoldKey(), userId.toString(), (Object)Boolean.TRUE);
        }
        this.distributedLock.unlock(userId.toString(), requestId);
        return message;
    }

    private KeyGenerator buildUserSendGoldKey() {
        return ActivityRedisKeyConstant.NEW_USER_SEND_GOLD;
    }

    public NewUserWelfareServiceImpl(RedisHashMapAdapter redisHashMapAdapter, AccountFacadeService accountFacadeService, NewbieWelfareConfig newbieWelfareConfig, DistributedLock distributedLock, SequenceCreater sequenceCreate) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.accountFacadeService = accountFacadeService;
        this.newbieWelfareConfig = newbieWelfareConfig;
        this.distributedLock = distributedLock;
        this.sequenceCreate = sequenceCreate;
    }
}

