package com.bxm.fossicker.admin.domain;

import com.bxm.fossicker.model.param.AdvertStatusParam;
import com.bxm.fossicker.model.vo.ActivityAdvertPositionRelationVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ActivityAdvertPositionRelationMapper {

    int deleteByPrimaryKey(Long id);

    int insert(ActivityAdvertPositionRelationVO record);

    int insertSelective(ActivityAdvertPositionRelationVO record);

    ActivityAdvertPositionRelationVO selectByPrimaryKey(Long id);

    List<Long> selectIdsByMaterialId(Long materialId);

    /**
     * 判断广告位是否存在指定排序的素材
     * @param positionId 广告位ID
     * @param order 排序位
     * @return 是否存在对应的数据
     */
    List<Long> existsPostionOrder(@Param("positionId") Long positionId, @Param("order") Integer order);

    /**
     * 广告位中的指定素材全部后移一位
     * @param positionId 广告位
     * @param order 排序位
     * @return 更新数据
     */
    int batchBack(@Param("positionId") Long positionId, @Param("order") Integer order);

    int updateByPrimaryKeySelective(ActivityAdvertPositionRelationVO record);

    int updateByPrimaryKey(ActivityAdvertPositionRelationVO record);

    int updateStatusType(AdvertStatusParam advertStatusParam);
}