package com.bxm.fossicker.admin.domain;

import com.bxm.fossicker.model.entity.TaskBean;
import com.bxm.fossicker.model.param.TaskAddParam;
import com.bxm.fossicker.model.param.TaskDeleteParam;
import com.bxm.fossicker.model.param.TaskEditParam;
import com.bxm.fossicker.model.param.TaskListPageParam;
import com.bxm.fossicker.model.vo.TaskListVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2019/10/14 10:17
 */
@Mapper
public interface ActivityTaskMapper {

    /**
     * 获取日常任务列表
     * @param param
     * @return
     */
    List<TaskListVo> getTaskList(TaskListPageParam param);

    List<TaskListVo> taskInfoByTaskCode(@Param("taskCode") String taskCode);

    /**
     * 新增
     * @param param
     * @return
     */
    int add(TaskBean param);

    int insertUserTask(@Param("taskCode") String taskCode);

    int update(TaskEditParam param);

    int delete(TaskDeleteParam param);

    /**
     * 获取存在排序位置的任务
     * @param order 排序位置
     * @return 任务编码
     */
    List<String> existsTaskCode(Integer order);

    /**
     * 移动任务排序
     * @param order 排序
     * @return 移动数量
     */
    int moveOrder(Integer order);

    TaskBean queryById(Long id);
}
