package com.bxm.fossicker.admin.domain;

import com.bxm.fossicker.model.entity.CommodityGoodsBean;
import com.bxm.fossicker.model.entity.CommodityGoodsPoolRelationBean;
import com.bxm.fossicker.model.entity.CommodityPoolTotal;
import com.bxm.fossicker.model.param.CommodityPoolGoodsListParam;
import com.bxm.fossicker.model.vo.CommodityStatusVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface CommodityGoodsPoolRelationMapper {
    int deleteByPrimaryKey(Long id);

    int insert(CommodityGoodsPoolRelationBean record);

    int insertSelective(CommodityGoodsPoolRelationBean record);

    CommodityGoodsPoolRelationBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(CommodityGoodsPoolRelationBean record);

    int updateByPrimaryKey(CommodityGoodsPoolRelationBean record);

    List<CommodityGoodsBean> listByParam(CommodityPoolGoodsListParam param);

    /**
     * 统计商品池下所有的商品售出总数（已移除的也会被查出来
     *
     * @param commodityPoolId 商品池id
     * @return
     * @deprecated
     */
    Long listByPoolId(Long commodityPoolId);

    /**
     * 查询商品池的汇总数据
     * @return 商品池的销售数据
     */
    List<CommodityPoolTotal> queryPoolTotal();

    /**
     * 判断商品池是否已经存在指定排序的商品
     * @param poolId 商品池ID
     * @param order 排序
     * @return 大于0表示存在
     */
    List<Long> hasOrder(@Param("poolId") Long poolId,@Param("order") Integer order);

    /**
     * 将商品池的order（包含）之后的商品排序位置+1
     * @param poolId 商品池ID
     * @param order 排序位
     * @return 移动数量
     */
    int moveOrder(@Param("poolId") Long poolId,@Param("order") Integer order);

    /**
     * 获取商品详情
     *
     * @param poolsId
     * @param goodsId
     * @return
     */
    CommodityGoodsPoolRelationBean getCommodityByPoolsId(@Param("poolsId") Long poolsId, @Param("goodsId") Long goodsId);

    /**
     * 商品池下商品上下架状态更改
     *
     * @param commodityStatusVO
     * @return
     */
    int updateCommodityStatus(CommodityStatusVO commodityStatusVO);

    /**
     * 批量添加上下架时间
     *
     * @param goodsList
     * @param poolsId
     * @param startTime
     * @param endTime
     * @return
     */
    int batchCommodityeffectiveTimer(@Param("goodsList") List<Long> goodsList, @Param("poolsId") Long poolsId, @Param("startTime") Date startTime, @Param("endTime") Date endTime);

    /**
     * 商品池商品上下架时间，排序更改
     *
     * @param updateBean
     * @return
     */
    int updateCommodityRelation(CommodityGoodsPoolRelationBean updateBean);

    /**
     *  根据商品池id批量查询对应的关系
     * @param pooIds
     * @return
     */
    List<CommodityGoodsPoolRelationBean> listByPooIds(List<Long> pooIds);

    /**
     * 根据商品id（库里的热不是三方的id）查询当前商品在哪些商品池下面
     * @param goodsId
     * @return
     */
    List<CommodityGoodsPoolRelationBean> listByGoodsId(Long goodsId);

}