package com.bxm.fossicker.admin.domain;

import com.bxm.fossicker.model.entity.CommonPopUpWindows;
import com.bxm.fossicker.model.param.PopUpListParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface CommonPopUpWindowsMapper {
    int deleteByPrimaryKey(Long id);

    int insert(CommonPopUpWindows record);

    int insertSelective(CommonPopUpWindows record);

    CommonPopUpWindows selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(CommonPopUpWindows record);

    int updateByPrimaryKey(CommonPopUpWindows record);


    /**
     *  根据类型查找弹窗
     *  只适用于功能弹窗和系统弹窗
     * @param type
     * @return
     */
    List<CommonPopUpWindows> selectByType(int type);

    /**
     * 根据请求参数查询列表
     * @param param
     * @return
     */
    List<CommonPopUpWindows> listByParam(PopUpListParam param);


    /**
     * 获取素材id对应的所有弹窗
     * @param materialId
     * @return
     */
    List<CommonPopUpWindows> selectByMaterialId(Long materialId);

    /**
     * 弹窗位置是否已经存在对应排序的弹窗
     * @param positionId 弹窗位置ID
     * @param order 排序
     * @return 弹窗ID
     */
    List<Long> existsWindow(@Param("positionId") Long positionId, @Param("order") Integer order);

    /**
     * 移动排序
     * @param positionId 弹窗位置ID
     * @param order 排序
     * @return 影响行数
     */
    int moveOrder(@Param("positionId") Long positionId, @Param("order") Integer order);
}