package com.bxm.fossicker.admin.domain;

import com.bxm.fossicker.model.param.SelectMaterilaParam;
import com.bxm.fossicker.model.vo.MaterialVO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Description: 素材管理 Mapper
 * @author: yangxin
 * @date: 2019/12/25  17:11
 */
@Mapper
public interface MaterialMapper {

    /**
     * id title查询素材
     * @param param
     * @return
     */
    List<MaterialVO> getMaterialByIdOrTitle(SelectMaterilaParam param);

    /**
     * 查询全部
     * @return
     */
    List<MaterialVO> getMaterialList();

    /**
     * 添加
     * @param materialVO
     * @return
     */
    int add(MaterialVO materialVO);

    /**
     * 删除
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 更新
     * @param materialVO
     * @return
     */
    int update(MaterialVO materialVO);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    MaterialVO getMaterialById(Long id);
}
