package com.bxm.fossicker.admin.domain;

import com.bxm.fossicker.model.dto.AdminPushMessageDTO;
import com.bxm.fossicker.model.param.PushMessageParam;
import com.bxm.fossicker.model.param.PushMessageRelationParam;
import com.bxm.fossicker.model.vo.AdminPushMessage;
import com.bxm.fossicker.model.vo.PushMessageRelationUser;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface PushMessageMapper {

    /**
     * 获取推送消息列表
     * @param messageId
     * @return
     */
    List<PushMessageRelationUser> getMessageRelation(@Param("messageId") Long messageId);

    /**
     * 根据对应参数获取平台信息
     * @param pushMessageRelationParam
     * @return
     */
    List<PushMessageRelationUser> getMessageByParam(PushMessageRelationParam pushMessageRelationParam);

    /**
     * 根据条件分页查询消息推送记录
     * @param pushMessageParam
     * @return
     */
    List<AdminPushMessageDTO> queryPushMessageByPageSize(PushMessageParam pushMessageParam);

    /**
     * 获取详情
     * @param id
     * @return
     */
    AdminPushMessage selectByPrimaryKey(Long id);

    /**
     * 添加推送消息
     * @param adminPushMessage
     * @return
     */
    int insertSelective(AdminPushMessage adminPushMessage);

    /**
     * 更新消息
     * @param adminPushMessage
     * @return
     */
    int updateByPrimaryKeySelective(AdminPushMessage adminPushMessage);

    /**
     * 批量更新
     * @param ids
     * @param status
     * @return
     */
    int updatePushMessageStatusByIds(@Param("ids") String[] ids, @Param("status") Byte status);

    /**
     * 更新消息状态
     * @param id
     * @param status
     * @return
     */
    int updatePushMessageStatus(@Param("id") Long id, @Param("status") Byte status);

    /**
     * 更新发送人数
     * @param id
     * @param status
     * @param userTotal
     * @return
     */
    int updatePushMessageUser(@Param("id") Long id, @Param("status") Byte status, @Param("userTotal") Long userTotal);
}
