package com.bxm.fossicker.admin.domain;

import com.bxm.fossicker.model.entity.UserInfoBean;
import com.bxm.fossicker.model.param.AppUserListParam;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface UserInfoMapper {


    UserInfoBean selectByPrimaryKey(Long id);

    UserInfoBean selectByPhone(String phone);

    UserInfoBean selectByInviteCode(String inviteCode);

    /**
     * 通过淘宝客会员id查询用户
     * @param specialId 淘宝客会员id
     */
    UserInfoBean selectBySpecialId(String specialId);

    /**
     * 通过淘宝客渠道id查询用户
     * @param relationId 淘宝客渠道id
     */
    UserInfoBean selectByRelationId(String relationId);

    int updateByPrimaryKeySelective(UserInfoBean record);

    /**
     * 将wechat字段设置为null
     * @param userId userId
     * @return
     */
    int setWechatToNull(Long userId);


    /**
     * 查询未注销用户
     * @param param
     * @return
     */
    List<UserInfoBean> listByParam(AppUserListParam param);
}