package com.bxm.fossicker.base.facade.param;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@ApiModel(description = "获取App版本更新信息参数")
@EqualsAndHashCode(callSuper = true)
@Data
public class AppVersionParam extends BaseBean {

    @ApiModelProperty(value = "通用参数：平台类型,1:ANDROID,2:IOS,3:WEB" ,required = true)
    private int platform;

    @ApiModelProperty(value = "通用参数：当前APP的发布版本",required = true)
    private String curVer;

    @ApiModelProperty(value = "通用参数：用户安装包渠道来源")
    private String chnl;

    @ApiModelProperty(value = "通用参数：设备编号")
    private String devcId;

    @ApiModelProperty(value = "通用参数：客户端时间，用于判断是否超时请求，如请求时间与服务端时间存在一定的差异，将会拒绝请求")
    private Long cliTime;

    public AppVersionParam(){}
    public AppVersionParam(int platform,String chnl){
        this.platform = platform;
        this.chnl = chnl;
    }
}
