package com.bxm.fossicker.base.facade.service;

import com.bxm.fossicker.base.facade.model.EquipmentDTO;
import com.bxm.fossicker.base.param.EquipmentParam;

/**
 * @Author: pf.w
 * @Date: 2019/10/28 14:14
 */
public interface EquipmentFacadeService {

    /**
     * 根据device id   获取设备信息
     *
     * @param deviceId 设备ID
     * @return 如果设备ID不存在则返回null
     */
    EquipmentDTO getByDeviceId(String deviceId);

    /**
     * 是否开启推送
     */
    boolean hasEnablePush(String deviceId);

    /**
     * 创建设备信息
     *
     * @param param 设备信息参数
     * @return 设备ID
     */
    String createEquipment(EquipmentParam param);

}
