package com.bxm.fossicker.base.bo;

import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.param.PopUpWindowsListParam;
import com.google.common.collect.Maps;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @authoer Gonzo
 * @date 2019-09-03 10:13
 */
@Data
@Builder
public class FilterPopUpWindowsBO {

    /**
     * 弹窗列表
     */
    private List<CommonPopUpWindowsEntry> popUpWindows;

    /**
     * 接口请求参数
     */
    private PopUpWindowsListParam param;


    /**
     * 用户的弹窗记录
     * key 弹窗id value 弹窗的弹出信息记录
     */
    Map<String, UserPopUpedBO> popUpedInfo;

    /**
     * 运行时参数
     */
    @Builder.Default
    private Map<String, Object> params = Maps.newHashMap();


    public void put(String key, Object val) {
        params.put(key, val);
    }

    public <T> T getParam(String key) {
        Object val = params.get(key);

        return val == null ? null : (T) val;
    }

}
