package com.bxm.fossicker.base.bo;

import com.bxm.fossicker.base.param.PopUpWindowsListParam;
import com.bxm.fossicker.base.vo.PopUpWindowsVO;
import com.google.common.collect.Maps;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @authoer Gonzo
 * @date 2019-09-03 10:13
 */
@Data
@Builder
public class PopUpWindowsBO {

    /**
     * 弹窗列表
     */
    private List<PopUpWindowsVO> popUpWindows;

    /**
     * 接口请求参数
     */
    private PopUpWindowsListParam param;


    /**
     * 运行时参数
     */
    @Builder.Default
    private Map<String, Object> params = Maps.newHashMap();


    public void put(String key, Object val) {
        params.put(key, val);
    }

    public <T> T getParam(String key) {
        Object val = params.get(key);

        return val == null ? null : (T) val;
    }
}
