package com.bxm.fossicker.base.bo;

import lombok.Data;

import java.util.Date;

/**
 * 用户对应的弹窗已弹出信息
 * @author Gonzo
 * @date 2019-10-10 15:45
 */
@Data
public class UserPopUpedBO {

    /**
     * 弹窗id
     */
    private Long popUpId;

    /**
     * 弹出的日期（用来记录当日是否弹出，如果判断day不为当日，则times重新计算）
     */
    private Date day;

    /**
     * 已弹出次数
     * 次数的定义跟弹窗的弹出类型相关，单单次数本身没有什么意义
     */
    private Integer times;


    /**
     * 永久关闭
     */
    private Boolean finalClose;

    /**
     * 弹窗类型：0：运营类弹窗不定义具体类型 | 1：版本更新弹窗 | 2：首页用户画像弹窗 | 3：首页任务弹窗 | 4：我的页面邀请弹窗
     */
    private Byte type;

    /**
     * 弹窗分类：1：系统弹窗 | 2：功能性弹窗 | 3：活动弹窗
     */
    private Byte category;


}
