package com.bxm.fossicker.base.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * @authoer Gonzo
 * @date 2019-09-03 11:25
 */
public class PopUpRedisConstant {

    private static KeyGenerator BASE_BASE_KEY = DefaultKeyGenerator.build().setModule("base");

    /**
     * 版本弹窗缓存
     * @deprecated
     */
    public static KeyGenerator VERSION_POPUP_WINDOWS_CACHE = BASE_BASE_KEY.copy().setGroup("versionPopUpWindowsCache");

    /**
     * 首页任务弹窗
     * @deprecated
     */
    public static KeyGenerator HOMEPAGE_TASK_POPUP_WINDOWS_CACHE = BASE_BASE_KEY.copy().setGroup("homePageTaskPopUpWindowsCache");

    /**
     * 我的页面邀请好友弹窗
     * @deprecated
     */
    public static KeyGenerator MINE_INVITE_POPUP_WINDOWS_CACHE = BASE_BASE_KEY.copy().setGroup("mineInvitePopUpWindowsCache");


    /**
     * 我的页面签到弹窗
     * @deprecated
     */
    public static KeyGenerator MINE_SIGN_POPUP_WINDOWS_CACHE = BASE_BASE_KEY.copy().setGroup("mineSignPopUpWindowsCache");



    private static KeyGenerator BASE_POPUP_KEY = DefaultKeyGenerator.build().setModule("base").setGroup("popUp");


    /**
     * 弹窗已展示次数
     */
    public static KeyGenerator VIEWED_COUNT_POPUP_CACHE = BASE_POPUP_KEY.copy().setKey("viewedCount");

    /**
     * 弹窗点击次数
     */
    public static KeyGenerator CLICK_COUNT_POPUP_CACHE = BASE_POPUP_KEY.copy().setKey("clickCount");


    /**
     * 用户的弹窗缓存
     */
    public static KeyGenerator USER_POPUP_CACHE = BASE_POPUP_KEY.copy().setKey("userPopupCache");


    /**
     * 弹窗的根据区域的缓存
     */
    public static KeyGenerator POP_UP_POSITION_CACHE = BASE_POPUP_KEY.copy().setKey("positionCache");


}
