package com.bxm.fossicker.base.entity;

import lombok.Data;

import java.util.Date;

/**
 * @authoer Gonzo
 * @date 2019-08-16 14:33
 */
@Data
public class AppChannelVersion {

    /**
     * 主键
     */
    private Long id;

    /**
     * 渠道id
     */
    private Long channelId;

    /**
     * 版本号
     */
    private String version;

    /**
     * 更新标题
     */
    private String title;

    /**
     * 更新内容
     */
    private String content;

    /**
     * 下载地址
     */
    private String downloadLink;

    /**
     * 是否强制更新 0.选择更新， 1.强制更新，2.静默更新，3.不用更新
     */
    private Byte isForce;

    /**
     * 是否处于提包状态 0.否 1.是
     */
    private Byte status;

    /**
     * 是否开启：0关闭 1开启
     */
    private Byte enable;

    /**
     * 强制更新范围（当前版本以及更低版本）
     */
    private String forceVersion;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 平台类型 1.安卓  2.ios
     */
    private Integer mobileType;

    /**
     * 渠道代码
     */
    private String code;

    /**
     * 渠道名称
     */
    private String name;

    /**
     * 联系人
     */
    private String linker;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 渠道类型    10 推广渠道,20 应用市场
     */
    private Byte type;
}
