package com.bxm.fossicker.base.entity;

import lombok.Data;

import java.util.Date;

/**
 * @author Gonzo
 * @date 2019-10-10 15:45
 */
@Data
public class CommonPopUpWindowsEntry {

    private Long id;

    /**
     * 弹窗名称
     */
    private String name;

    /**
     * 弹窗类型：0：运营类弹窗不定义具体类型 | 1：版本更新弹窗 | 2：首页用户画像弹窗 | 3：首页任务弹窗 | 4：我的页面邀请弹窗
     */
    private Byte type;

    /**
     * 弹窗分类：1：系统弹窗 | 2：功能性弹窗 | 3：活动弹窗
     */
    private Byte category;

    /**
     * 弹窗顺序 在同一个position下，从小到大，越小优先级越高，越小就最先弹出
     */
    private Integer tOrder;

    /**
     * 弹窗规则id
     */
    private Long ruleId;

    /**
     * 弹窗素材id
     */
    private Long materialId;

    /**
     * 启用开始时间
     */
    private Date startTime;

    /**
     * 启用结束时间
     */
    private Date endTime;

    /**
     * 素材名称
     */
    private String materialName;

    /**
     * 图片url
     */
    private String imgUrl;

    /**
     * 图片宽
     */
    private Integer width;

    /**
     * 图片高
     */
    private Integer height;

    /**
     * 跳转类型：1：打开商品 2：跳转url
     */
    private Byte jumpType;

    /**
     * 跳转url（如果是商品，则最终也是拼接成的url）
     */
    private String jumpUrl;

    /**
     * 素材分类：1：系统弹窗 | 2：功能性弹窗 | 3：活动弹窗（这里区分出来是因为除了活动弹窗其他都无法配置，但是其他弹窗也有这些属性）
     */
    private Byte materialCategory;

    /**
     * 弹窗的拓展数据（功能性or系统性弹窗可能会有一些固定的拓展信息，就放到这里保存了）
     */
    private String materialExt;

    /**
     * 规则名称
     */
    private String ruleName;

    /**
     * 弹窗展示用户类型：0：全部用户 1：新用户 2：老用户 3：未下单用户 4：已下单用户 5：自定义用户id
     * 6：未开卡用户（未购买终身黑钻卡的用户）7：非会员用户 8：（会员用户：包括月卡在有效期内的用户以及领取黑钻卡的用户）
     */
    private Byte userType;

    /**
     * 登录状态：0：全部 1：未登录 2：已登录
     */
    private Byte loginType;

    /**
     * 自定义用户id集合json
     */
    private String userIds;

    /**
     * 弹窗位置：1：首页 2：我的页面 3：超级入口 4：任务页
     */
    private Integer position;

    /**
     * 弹出频率：1：累计弹出次数 2：每日弹出次数
     */
    private Byte frequencyType;

    /**
     * 弹出次数，配合frequency_type食用
     */
    private Integer times;

    /**
     * 审核状态下是否隐藏 0：否 | 1：是
     */
    private Byte auditHide;

    /**
     * 平台类型 ：0：所有 | 1：Android | 2：IOS | 3：WEB
     */
    private Byte platform;

    /**
     * 互斥类型，json数据，定义了互斥类型和互斥的id或者其他
     */
    private String exclusionJson;


    /**
     * 弹出时机 0：立即弹出 否则就是访问对应的数值时弹出
     */
    private Byte popUpOpportunity;

    /**
     * 版本过滤，json数据，定义了大于or小于or版本的版本弹窗
     */
    private String versionJson;

    private String ext;
}
