package com.bxm.fossicker.base.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * t_common_pop_up_windows_material
 * @author 
 */
public class CommonPopUpWindowsMaterial implements Serializable {
    private Long id;

    /**
     * 素材名称
     */
    private String name;

    /**
     * 图片url
     */
    private String imgUrl;

    /**
     * 跳转类型：1：打开商品 2：跳转url
     */
    private Byte jumpType;

    /**
     * 跳转url（如果是商品，则最终也是拼接成的url）
     */
    private String jumpUrl;

    /**
     * 素材分类：1：系统弹窗 | 2：功能性弹窗 | 3：活动弹窗（这里区分出来是因为除了活动弹窗其他都无法配置，但是其他弹窗也有这些属性）
     */
    private Boolean category;

    /**
     * 是否删除0:否 1:是
     */
    private Boolean deleteFlag;

    /**
     * 删除时间
     */
    private Date deleteTime;

    private Date modifyTime;

    private Date createTime;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Byte getJumpType() {
        return jumpType;
    }

    public void setJumpType(Byte jumpType) {
        this.jumpType = jumpType;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public Boolean getCategory() {
        return category;
    }

    public void setCategory(Boolean category) {
        this.category = category;
    }

    public Boolean getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Boolean deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Date getDeleteTime() {
        return deleteTime;
    }

    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}