package com.bxm.fossicker.base.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * t_pop_up_windows
 * @author 
 */
@Data
public class PopUpWindows implements Serializable {
    private Long id;

    /**
     * 弹窗名称
     */
    private String name;

    /**
     * 跳转协议
     */
    private String url;

    /**
     * 弹窗类型：1：版本更新弹窗 | 2：首页用户画像弹窗 | 3：首页任务弹窗 | 4：我的页面邀请弹窗
     */
    private Byte type;

    /**
     * 弹窗分类：1：系统弹窗 | 2：功能性弹窗 | 3：活动弹窗
     */
    private Byte category;

    /**
     * 弹窗位置：1：首页 | 2：我的页面
     */
    private Byte position;

    /**
     * 弹窗顺序 在同一个position下，从小到大，越小优先级越高，越小就最先弹出
     */
    private Byte order;

    /**
     * 审核状态下是否隐藏 0：否 | 1：是
     */
    private Byte auditHide;

    /**
     * 平台类型 0：所有 | 1：Android | 2：IOS | 3：WEB
     */
    private Byte platform;

    /**
     * 是否删除0:否 1:是
     */
    private Byte deleteFlag;

    /**
     * 删除时间
     */
    private Date deleteTime;

    private Date modifyTime;

    private Date createTime;

}