package com.bxm.fossicker.base.enums;

/**
 * @authoer Gonzo
 * @date 2019-09-03 10:29
 * 弹窗类型
 */
public enum PopUpEnum {

    /**
     * 未定义的弹窗信息
     */
    NONE((byte)0, "未定义的弹窗信息"),

    HOME_VERSION((byte)1, "首页版本更新弹窗"),
    HOME_USER_PAINT((byte)2, "首页首页用户画像弹窗"),
    HOME_HOMEPAGE_TASK((byte)3, "首页任务弹窗"),
    MINE_INVITE((byte)4, "我的页面邀请弹窗"),
    HOME_NOVICE((byte)5, "首页新人弹窗"),
    TASK_SIGN((byte)6, "任务页签到弹窗"),
    HOME_SIGN_GUIDE((byte)7, "首页签到引导弹窗"),
    TASK_NOVICE_SEVEN((byte)8, "任务页新人7日红包弹窗"),
    TASK_TEACH_VIDEO((byte)9, "任务页教学视频弹窗"),
    TASK_TAOBAO_AUTH((byte)10, "任务页淘宝授权弹窗"),
    TASK_FIRST_BROWSE((byte)11, "任务页首次浏览获得金币弹窗"),
    TASK_TAOBAO_SEARCH((byte)12, "任务页搜索淘宝标题弹窗"),
    MINE_TREASURE_BOX((byte)13, "我的页面宝箱弹窗"),
    HOME_NOVICE_GUIDE((byte)14, "首页新人引导弹窗"),
    ORDER_FOLLOW_SUCCESS((byte)15, "订单跟单成功弹窗"),
    TOBE_VIP_NOTICE((byte)16, "成为会员通知"),
    TOBE_VIP_INVITE_SPEED((byte)17, "邀请进度弹窗"),
    TASK_SIGN_AMOUNT((byte)18, "任务页显示签到奖励弹窗"),
    HOME_LOGIN_REWARD((byte)19, "首页登录奖励弹窗"),
    LOTTERY_HOME((byte)20, "全民大抽奖首页弹窗"),
    TOBE_FOREVER_VIP_NOTICE((byte)21, "成为终身会员通知"),
    GOLD_RATE_CHANGE((byte)22, "金币兑换比例调整弹窗"),
    ;


    private byte type;

    private String des;

    PopUpEnum(byte type, String des) {
        this.type = type;
        this.des = des;
    }


    public byte getType() {
        return type;
    }

    public String getDes() {
        return des;
    }

    public static PopUpEnum getByType(byte type) {

        for (PopUpEnum value : PopUpEnum.values()) {
            if (value.type == type) {
                return value;
            }
        }

        return null;
    }
}
