package com.bxm.fossicker.base.enums;

/**
 * 弹窗区域
 * @Author: Gonzo
 * @Date 2020-02-11 19:14
 * @since 1.5.0
 */
public enum PopUpPosition {
    /**
     * 首页
     */
    HOME_PAGE((byte) 1, "首页"),
    /**
     * 我的页面
     */
    MINE_PAGE((byte) 2, "我的页面"),
    /**
     * 超级入口
     */
    SUPER_PAGE((byte) 3, "超级入口"),
    /**
     * 任务页
     */
    TASK_PAGE((byte) 4, "任务页"),
    /**
     * 会员中心
     */
    VIP_PAGE((byte) 5, "会员中心"),
    /**
     * 邀请页面
     */
    INVITE_PAGE((byte) 6, "邀请页面"),

    /**
     * 全名大抽奖首页
     */
    LOTTERY_HOME_PAGE((byte) 7, "全名大抽奖首页"),

    ;

    private byte position;
    private String des;

    PopUpPosition(byte position, String des) {
        this.position = position;
        this.des = des;
    }

    public byte getPosition() {
        return position;
    }

    public String getDes() {
        return des;
    }
}
