package com.bxm.fossicker.base.enums;

/**
 * 定义处理器的执行顺序
 * order越小越先执行
 *
 * @author Gonzo
 * @date 2019-10-12 14:09
 */
public enum  PopUpProcessOrderEn {

    /**
     * 通用型处理器
     */
    GENERAL(50, "通用型处理器"),

    /**
     * 特殊指定型处理器
     */
    CUSTOM(GENERAL.order + 1, "特殊指定型处理器"),


    /**
     * 一些需要后置处理的过滤器
     */
    OPPORTUNITY(CUSTOM.order + 1, "弹出时机过滤器"),
    EXCLUSION(OPPORTUNITY.order + 1, "互斥过滤器"),
    RECORD_TIMES(EXCLUSION.order + 1, "弹出次数处理器，最后执行"),
    ;

    /**
     * 排序
     */
    private int order;

    /**
     * 描述
     */
    private String des;

    PopUpProcessOrderEn(String des) {
        this.des = des;
    }

    PopUpProcessOrderEn(int order, String des) {
        this.order = order;
        this.des = des;
    }


    public int getOrder() {
        return order;
    }

    public String getDes() {
        return des;
    }
}
