package com.bxm.fossicker.base.param;

import com.bxm.fossicker.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @authoer Gonzo
 * @date 2019-09-03 11:06
 */
@Data
@ApiModel(description = "用户关闭弹窗事件上传参数")
public class PopUpWindowsCloseParam extends BasicParam {

    @ApiModelProperty(value = "用户id")
    private Long userId;

    /**
     * @see com.bxm.fossicker.base.enums.PopUpEnum
     */
    @ApiModelProperty(value = "弹窗类型：1：版本更新弹窗 | 2：首页用户画像弹窗 | 3：首页任务弹窗 | 4：我的页面邀请弹窗 |6:签到弹窗 ")
    private Byte type;

    @ApiModelProperty(value = "弹窗id")
    private Long popUpId;

}
