package com.bxm.fossicker.base.param;

import com.bxm.fossicker.base.enums.PopUpPosition;
import com.bxm.fossicker.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author Gonzo
 * @date 2019-09-02 18:40
 */
@Data
@ApiModel(description = "获取弹窗列表参数")
public class PopUpWindowsListParam extends BasicParam {

    /**
     * @see PopUpPosition
     */
    @ApiModelProperty(value = "弹窗位置：1：首页 2：我的页面 3：超级入口 4：任务页 5:会员中心 6:邀请页面 7:全名大抽奖首页",
            required = true)
    private Byte position;

    @ApiModelProperty(value = "用户id")
    private Long userId;

}
