package com.bxm.fossicker.base.vo;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;
import java.util.Objects;

/**
 * c_equipment_info
 *
 * @author
 */
@Data
@Builder
public class EquipmentExtInfo extends BaseBean {
    private static final long serialVersionUID = 1L;

    /**
     * 设备唯一id，由服务端下发
     */
    private Long id;

    /**
     * 设备标识名称 ANDROID_IMEI ANDROID_ID ANDROID_UUID IOS_IDFA IOS_DEVICE_ID
     */
    private String identifierName;

    /**
     * 设备标识值
     */
    private String identifierValue;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date modifyTime;

    @Tolerate
    public EquipmentExtInfo() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EquipmentExtInfo that = (EquipmentExtInfo) o;
        return Objects.equals(identifierName, that.identifierName) &&
                Objects.equals(identifierValue, that.identifierValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), identifierName, identifierValue);
    }
}