package com.bxm.fossicker.base.vo;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;
import java.util.Objects;

/**
 * c_equipment_extra_info
 *
 * @author
 */
@Data
@Builder
public class EquipmentInfo extends BaseBean {

    @Tolerate
    public EquipmentInfo() {

    }

    private static final long serialVersionUID = 1L;

    /**
     * 设备唯一标识
     */
    private Long id;

    /**
     * 是否开启消息通知
     */
    private Boolean enableNotification;

    /**
     * 手机型号
     */
    private String phoneModel;

    /**
     * 当前版本
     */
    private String currentVersion;

    /**
     * 操作系统
     */
    private String operatingSystem;

    /**
     * 平台类型
     */
    private Integer platform;

    private Date createTime;

    private Date modifyTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EquipmentInfo that = (EquipmentInfo) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(enableNotification, that.enableNotification) &&
                Objects.equals(phoneModel, that.phoneModel) &&
                Objects.equals(currentVersion, that.currentVersion) &&
                Objects.equals(operatingSystem, that.operatingSystem);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), id, enableNotification, phoneModel, currentVersion, operatingSystem);
    }
}