package com.bxm.fossicker.base.vo;

import com.bxm.fossicker.base.enums.PopUpEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * t_pop_up_windows
 * @author 
 */
@Data
@ApiModel(description = "app版本更新信息")
@Builder
public class PopUpWindowsVO implements Serializable {

    @ApiModelProperty("弹窗名称")
    private String name;

    /**
     * @see PopUpEnum
     */
    @ApiModelProperty("弹窗类型：0：运营类弹窗 | 1：版本更新弹窗 | 2：首页用户画像弹窗 | 3：首页任务弹窗 | 4：我的页面邀请弹窗 | 5：首页新人弹窗 |6：签到弹窗 | 7: 首页签到引导弹窗 " +
            "|8:任务页新人7日红包弹窗 | 9: 任务页教学视频弹窗 | 10: 任务页淘宝授权弹窗 | 11 : 任务页首次浏览获得金币弹窗 |12 : 任务页搜索淘宝标题弹窗 | 13:我的页面宝箱弹窗 | 14:" +
            " 首页新人引导弹窗 | 15 :订单跟单成功弹窗 | 16 : 成为会员通知 | 17 : 邀请进度弹窗 |  18 : 签到显示奖励金额弹窗 | 19 : 首页登录奖励弹窗 | 20 : 全民大抽奖首页弹窗 | 21：成为终身会员通知" +
            "22 : 金币兑换比例调整弹窗 | 23：会员礼包0元领取弹窗")
    private Byte type;

    @ApiModelProperty(value = "弹窗顺序 在同一个position下，从小到大，越小优先级越高，越小就最先弹出", hidden = true)
    private Byte order;

    @ApiModelProperty(value = "审核状态下是否隐藏 0：否 | 1：是", hidden = true)
    private Byte auditHide;

    @ApiModelProperty("跳转协议")
    private String url;

    @ApiModelProperty("图片地址")
    private String imgUrl;

    @ApiModelProperty("图片宽")
    private Integer width;

    @ApiModelProperty("图片高")
    private Integer height;

    @ApiModelProperty("拓展json数据 承载某些弹窗需要的数据，如版本更新的数据")
    private String ext;

    @ApiModelProperty("弹窗id")
    private Long id;
}