package com.bxm.fossicker.commodity.model.constant;

/**
 * 查询商品信息时，返回的错误状态
 * @Author: Gonzo
 * @date  2020-03-04 14:53
 * @since 1.6.0
 */
public enum  CommodityDetailResultCode {
    /**
     * 查询成功
     */
    SUCCESS(0, "查询成功"),

    /**
     * 商品在黑名单中
     */
    IN_BLACK(1, "商品在黑名单中"),

    /**
     * 商品不在本地库中
     */
    NOT_IN_LOCAL(2, "商品不在本地库中"),

    /**
     * 商品在本地库中已下架
     */
    LOCAL_DOWN(3, "商品在本地库中已下架"),

    /**
     * 商品查询不存在
     */
    NOT_FOUND(404, "商品查询不存在（不在本地库，三方也查询不到）"),

    /**
     * 新人商品价格校验不通过
     */
    NOVICE_PRICE_NOT_VALIDATE(5, "新人商品价格校验不通过"),

    /**
     * 商品价格信息获取失败
     */
    PRICE_ERROR(6, "商品价格信息获取失败（获取佣金比例出错）"),

    /**
     * 商品佣金、原价价格校验失败
     */
    PRICE_NOTE_VALIDATE(7, "商品佣金、原价价格校验失败"),



    /**
     * 商品优惠券、佣金获取失败
     */
    PRICE_INFO_NOT_FOUND(8, "商品优惠券、佣金获取失败"),

    /**
     * 商品是一个vip 0元购商品
     */
    VIP_ZERO_CHECK_FAILED(9, "商品是一个vip 0元购商品，且校验不通过"),

    /**
     * 使用维易信息转换出现错误-数据来源类型不存在
     */
    WY_INFO_ERROR(10, "使用维易信息转换出现错误-数据来源类型不存在"),

    /**
     * 商品优惠券价格校验失败
     */
    COUPON_PRICE_NOTE_VALIDATE(11, "商品价格校验失败, 优惠券为0"),

    /**
     * 商品优惠券价格校验失败
     */
    BASE_INFO_NOT_FOUND(12, "商品基本信息获取失败（标题、首图、店铺信息等）"),
    ;

    /**
     * 结果码
     */
    private int code;

    /**
     * 结果描述
     */
    private String desc;

    CommodityDetailResultCode(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
